<!-- gatherRules.xsl, part of ITS general decorator 0.1
For documentation, see http://www.w3.org/International/its/wiki/ITS_General_Decorator

 -->
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink"
  version="1.0" exclude-result-prefixes="datc" xmlns:datc="http://example.com/datacats">

  <xsl:output method="xml" encoding="utf-8" indent="yes"/>  
  <xsl:param name="datacat"/>
  <xsl:param name="rulesElement" select="document('sampleCatDesc.xml')//datc:datacat[@name=$datacat]/datc:rulesElement/@name"/>
  <xsl:param name="externalRules">none</xsl:param>

  <xsl:template match="/">
    <its:rules version="1.0">
    <xsl:if test="$externalRules!='none'">
      <xsl:for-each select="document($externalRules)//its:rules">
        <xsl:call-template name="gatherRules"/>
      </xsl:for-each>
    </xsl:if>
    <xsl:for-each select="//its:rules">
      <xsl:call-template name="gatherRules"/>
    </xsl:for-each>
    </its:rules>
  </xsl:template>

  <!-- Gathering global rules from input document and optionally from external file -->
  <xsl:template name="gatherRules">
    <xsl:if test="@xlink:href" xmlns:xlink="http://www.w3.org/1999/xlink">
      <xsl:for-each select="document(@xlink:href)//its:rules">
        <xsl:call-template name="gatherRules"/>
      </xsl:for-each>
    </xsl:if>
    <xsl:for-each select="*[name()=$rulesElement or local-name()=$rulesElement or concat('its:',local-name())=$rulesElement]">
      <xsl:copy-of select="."/>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
