<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" 	
	xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
	xmlns:datc="http://example.com/datacats"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" exclude-result-prefixes="xsl datc"
	xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:strip-space elements="*"/>
	<xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>
	<xsl:param name="inputfile"/>
	<xsl:param name="datacat"/>
	<xsl:param name="rulesElement"
		select="document('sampleCatDesc.xml')//datc:datacat[@name=$datacat]/datc:rulesElement/@name"/>
	<xsl:template match="/">
		<!-- Write general stylesheet stuff -->
		<XSL:stylesheet version="1.0" xmlns:its="http://www.w3.org/2005/11/its"			
			xmlns:itsx="http://www.w3.org/2008/12/its-extensions"
			xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			exclude-result-prefixes="itsx its xlink">
			<XSL:output method="xml" indent="yes" encoding="utf-8"/>
			<xsl:for-each select="//datc:datacat[@name=$datacat]">
				<XSL:template match="/">
					<XSL:apply-templates mode="{@name}"/>
				</XSL:template>
				<xsl:call-template name="inheritanceTemplate"/>
			</xsl:for-each>
		</XSL:stylesheet>
	</xsl:template>
	<xsl:template name="inheritanceTemplate">
		<XSL:template match="itsAttributeAnnotation | itsElementAnnotation" mode="{@name}" priority="+1000">
			<XSL:copy-of select="self::*"/>
		</XSL:template>
		<XSL:template match="*" mode="{@name}">
			<XSL:copy>
				<XSL:copy-of select="@*"/>
				<XSL:apply-templates mode="{@name}" select="@*"/>
				<XSL:if test="not(itsElementAnnotation[@datacat='{@name}'])">
					<!-- inheritance no - default yes -->
					<xsl:if
						test="datc:defaults/datc:defaultsElements and datc:inheritance/@appliesTo='none'">
						<itsElementAnnotation datacat="{@name}">
							<xsl:copy-of
								select="datc:defaults/datc:defaultsElements/@* |
								datc:defaults/datc:defaultsElement/*"
							/>
						</itsElementAnnotation>
					</xsl:if>
					<!--  inheritance yes - default yes or no -->
					<xsl:if test="not(datc:inheritance/@appliesTo='none')">
						<XSL:choose>
							<XSL:when test="ancestor::itsElementAnnotation[@datacat='{$datacat}']">
								<XSL:copy-of
									select="ancestor::itsElementAnnotation[@datacat='{$datacat}'][last()]"
								/>
							</XSL:when>
							<XSL:otherwise>
								<itsElementAnnotation datacat="{@name}">
									<!-- defaults yes -->
									<xsl:if test="datc:defaults/datc:defaultsElements">
										<xsl:copy-of
											select="datc:defaults/datc:defaultsElements/@* |
									datc:defaults/datc:defaultsElement/*"
										/>
									</xsl:if>
								</itsElementAnnotation>
							</XSL:otherwise>
						</XSL:choose>
					</xsl:if>
					<!-- inheritance no - default no -->
					<xsl:if
						test="datc:inheritance/@appliesTo='none' and not(datc:defaults/datc:defaultsElements)">
						<itsElementAnnotation datacat="{@name}"/>
					</xsl:if>
				</XSL:if>
				<XSL:apply-templates mode="{@name}" select="node()"/>
			</XSL:copy>
		</XSL:template>
		<XSL:template match="@*" mode="{@name}">
			<XSL:variable name="name" select="name()"/>
			<XSL:choose>
				<XSL:when
					test="../itsAttributeAnnotation[@datacat='{$datacat}' and @attribute=$name]"/>
				<XSL:otherwise>
					<!-- inheritance no, defaults yes or no -->
					<xsl:if
						test="datc:inheritance/@appliesTo='onlyElements' or datc:inheritance/@appliesTo='none'">
						<itsAttributeAnnotation datacat="{@name}" attribute="{{name()}}">
							<!-- defaults yes  -->
							<xsl:if test="datc:defaults">
								<xsl:copy-of
									select="datc:defaults/datc:defaultsAttributes/@* |
			     datc:defaults/datc:defaultsAttributes/*"
								/>
							</xsl:if>
						</itsAttributeAnnotation>
					</xsl:if>
					<!-- inheritance yes, defaults yes or no -->
					<xsl:if test="datc:inheritance/@appliesTo='elementsAndAttributes'">
						<XSL:choose>
							<XSL:when test="ancestor::itsElementAnnotation[@datacat='{$datacat}']">
								<itsAttributeAnnotation datacat="{$datacat}" attribute="{{name()}}">
									<XSL:apply-templates
										select="ancestor::itsElementAnnotation[@datacat='{$datacat}'][last()]/@* | ancestor::itsElementAnnotation[@datacat='{$datacat}'][last()]/node()"
										mode="copy"/>
								</itsAttributeAnnotation>
							</XSL:when>
							<XSL:otherwise>
								<itsAttributeAnnotation datacat="{@name}" attribute="{{name()}}">
									<!-- defaults yes -->
									<xsl:if test="datc:defaults/datc:defaultsAttributes">
										<xsl:copy-of
											select="datc:defaults/datc:defaultsAttributes/@* |
									datc:defaults/datc:defaultsAttributes/*"
										/>
									</xsl:if>
								</itsAttributeAnnotation>
							</XSL:otherwise>
						</XSL:choose>
					</xsl:if>
				</XSL:otherwise>
			</XSL:choose>
		</XSL:template>
		<XSL:template match="node() | @*" mode="copy">
			<XSL:copy>
				<XSL:apply-templates select="node() | @*" mode="copy"/>
			</XSL:copy>
		</XSL:template>
	</xsl:template>
</xsl:stylesheet>
