/*
 * export.h -- header file for programs that use cexport
 *
 * $Id: export.h,v 1.3 93/05/07 10:20:31 bert Exp $
 *
 * Functions, type definitions, variable declarations can all be
 * exported by putting EXPORT (uppercase only) in front of the
 * declaration. The declarations must be ANSI-C. Macros can be
 * exported with EXPORTDEF. Examples:
 *
 * EXPORT int sqr(int n) {...}		-- exports function sqr()
 * EXPORT typedef struct _Str * MyStr;	-- exports type MyStr
 * EXPORT int maximum;			-- exports variable maximum
 * #define max(a,b) ((a)>(b)?(a):(b))
 * EXPORTDEF(max(a,b))			-- exports macro max(a,b)
 */
#ifndef _EXPORT_H_
#define _EXPORT_H_

#ifndef __export
#define EXPORT /* nothing */
#define EXPORTDEF(x) /* nothing */
#else
#define EXPORTDEF(x) EXPORTDEF_##x x
#endif

#endif /* _EXPORT_H_ */
