/*
 *  StringToURL.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: StringToURL.java,v 1.1 1997/04/15 20:39:33 yhchu Exp $
 */

package w3c.www.pics;

import java.net.URL;
import java.net.MalformedURLException;

public class StringToURL implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    try {
      return new URL((String)value);
    }
    catch (MalformedURLException e) {
      throw new PICSParserException("Unable to parse a URL", e);
    }
  }

}
