/*
 *  RatingValue.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: RatingValue.java,v 1.1 1997/04/15 20:39:31 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Vector;

public class RatingValue {

  private double values[];
  private boolean isSingle;

  // single value
  public RatingValue(double value)
  {
    this.values = new double[1];
    this.values[0] = value;
    this.isSingle = true;
  }

  // multiple value [1 2 3]
  public RatingValue(double values[])
  {
    this.values = values;
    this.isSingle = false;
  }

  // a vector of value [ [1 2] 3 ]
  public RatingValue(Vector data)
  {
    this.values = new double[data.size()];
    for (int i = 0; i < data.size(); i++)
      this.values[i] = ((Number)data.elementAt(i)).doubleValue();
    this.isSingle = false;
  }

  public boolean isSingleNumber()
  {
    return isSingle;
  }

  public boolean allInRange(double lo, double hi)
  {
    for (int i = 0; i < values.length; i++) {
      double v = values[i];
      if (lo > v || v > hi)
    	return false;
    }
    return true;
  }

  public boolean anyInRange(double lo, double hi)
  {
    for (int i = 0; i < values.length; i++) {
      double v = values[i];
      if (lo <= v && v <= hi)
      return true;
    }
    return false;
  }

  public double[] getValues()
  {
    return values;
  }

  public double getValue() throws MultipleValueAccessException
  {
    if (isSingle || values.length == 1)
      return values[0];
    else
      throw new MultipleValueAccessException();
  }

  // how is range represented?
  public String toString()
  {
    String s = "" + this.values[0];
    if (isSingleNumber())
      return s;
    for (int i = 1; i < values.length; i++) 
      s += " " + this.values[i];
    return s;
  }
}
