// eccDsig.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;
import w3c.www.dsig.*;

public class eccDsig
{

  public native void    ecc_init();

  //interface that exports a SHA-1 hash value to java
  public native Sha1Hash ecc_getSHA1(byte [] hv);

  //interfaces that export keys and signatures to java
  public native EccKeyPair ecc_genKeyPair();
  public native ecSig   ecc_Sign(byte [] sd, byte [] privk);
  public native boolean ecc_Verify(ecSig sig, byte [] sd, EccPubKey pk);

  //interfaces using and passing handles
  public native int     ecc_genKeyPair_handle();
  public native byte [] ecc_getPriv_with_handle(int kph);
  public native EccPubKey  ecc_getPub_with_handle(int kph);
  public native EccKeyPair ecc_getKeyPair_with_handle(int kph);
  public native int     ecc_Sign_with_handle(byte [] sd, int kph);
  public native ecSig   ecc_getSig_with_handle(int sh);
  public native boolean ecc_Verify_with_handle(int sh, byte [] sd, int kh);

  static {
    System.loadLibrary("eccw3c");
  }

}
