// DSigLabelInterface.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;
import java.util.*;

/**
 * DSig-1.0 defines two PICS-1.1 extensions.  The DSig library is therefore
 * written as an extension to an existing PICS Parser or Label object. 
 * This interface defines the necessary methods for a given PICS label
 * object to use the DSig-1.0 library, since these methods may be called
 * inside the DSig library during the course of a DSig evaluation.
 *
 * @author Yang-hua Chu
 * @version 1.0 (last modified 10-February-1998)
 */

public interface DSigLabelInterface 
{

  /**
   * Get the 'for' attribute of the PICS-1.1 option
   */
  public String getFor();

  /**
   * The changes made in ResInfo and SigBlock extension may not be automatic;
   * calling this method updates the original PICS1.1 Label and reflect
   * the changes in resinfo and sigblock for the given PICS Label object
   * implementing the DSigLabelInterface.
   */
  public void updateDSig();

  /**
   * Set the DSig Resource Information (resinfo).
   */
  public SigBlockExtension getSigBlock();

  /**
   * Set the DSig Signature Block (sigblock)
   */
  public void setSigBlock(SigBlockExtension sigblock);

  /**
   * Get the DSig Resource Information (resinfo).
   */
  public ResInfoExtension getResInfo();

  /**
   * Set the DSig Resource Information (resinfo).
   */
  public void setResInfo(ResInfoExtension resinfo);

  /**
   * Returns the canonicallized form of the DSig label with fields
   * selectively included or excluded according the sigdata.  Please refer
   * to the DSig Label specification for more detail.
   * @exception DSigException if the format of the sigdata is incorrect.
   */
  public String toExcludedDSigString(Hashtable sigdata) throws DSigException;

  /**
   * Returns a String containing the canonical PICS 1.1 representation of 
   * this Label, suitable for signing.
   * @return A String with a valid canonicalized PICS 1.1 label 
   * representation of this Label object.
   **/
  public String toDSigString();
}
