// DSAParamsClass.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;

import java.math.BigInteger;
import java.security.interfaces.*;

/**
 * An implementation of the <CODE>java.security.interfaces.DSAParams</CODE>
 * interface. This was written because generating a DSA parameters object
 * from given parameters using the JDK implementation in the Sun
 * provider is not possible by via the security interfaces (BUG!).
 *
 * @author Andreas Sterbenz
 * @version 1.0 (last modified 17-oct-1997)
 */
public class DSAParamsClass implements DSAParams
{
  private BigInteger p;
  private BigInteger q;
  private BigInteger g;

  /**
   * Create a new DSA parameters object from the given BigInteger
   * parameters.
   */
  public DSAParamsClass(BigInteger p, BigInteger q, BigInteger g)
  {
    this.p = p;
    this.q = q;
    this.g = g;
  }

  /**
   * Return a new DSA parameters object from the given BigInteger
   * parameters. This is equivalent to using the constructor with new()
   * except that this method could be declared in an interface (which
   * it currently is not) while constructors cannot.
   */
  public static DSAParamsClass newDSAParamsClass(BigInteger p, BigInteger q, BigInteger g)
  {
    return new DSAParamsClass(p, q, g);
  }

  public BigInteger getP()
  {
    return this.p;
  }

  public BigInteger getQ()
  {
    return this.q;
  }

  public BigInteger getG()
  {
    return this.g;
  }
}
