package w3c.pics.parser;

import java.util.*;

/**
 * A class representing a single PICS rating for use as part of a label.
 * A Rating can either be a single value or a range of values.
 **/

public class Rating implements java.io.Serializable
{
  double a, b;
  boolean range = false;

  /**
   * Creates a new single-value Rating.
   * @param a The value for the Rating.
   **/

  public Rating(double a) 
  {
    this.a = a;
  }

  /**
   * Creates a new range-valued Rating.
   * @param a The minimum value of the range.
   * @param b The maximum value of the range.
   **/

  public Rating(double a, double b) 
  {
    this.a = a;
    this.b = b;
    range = true;
  }

  /**
   * Writes the rating out in PICS format.
   * @return A String of the rating in the PICS format.
   **/

  public String toString()
  {
    if (range)
      return new Double(a).toString() + ":" + new Double(b).toString();
    else
      return new Double(a).toString();
  }  

  /**
   * Writes the rating in DSig1.0 label format.
   * @return A String of the rating in DSig1.0 label format.
   **/

  public String toDsigString() {
    if (range)
      return new Double(a).toString() +" : "+new Double(b).toString();
    else
      return new Double(a).toString();
  }

  /**
   * Returns a boolean indicating if this Rating is a range or not.
   * @return A boolean, <strong>true</strong> if this Rating is a range, 
   * <strong>false</strong> if this rating is a single value.
   **/

  public boolean isRange() {
    return range;
  }

  /**
   * Writes the rating out separated by a comma, if necessary.
   * @return  e.g. "a, b" or "a"
   **/

  public String toCommaDelimString()
  {
    if (range)
      return new Double(a).toString() + ", " + new Double(b).toString();
    else
      return new Double(a).toString();
  }

}
