/* JJT: 0.2.2 */

package w3c.pics.parser;


class PICSPath_Node extends SimpleNode implements URLEvalNode {
  PICSPath_Node(int id) {
    super(id);
  }

  String text = null;
  
  public String getText() {
    return text;
  }

  public boolean isValid(String URL) {
    int doubleslash = URL.indexOf("//");
    String noscheme = URL.substring(doubleslash+2);
    int slash = noscheme.indexOf("/");
    if (text.equals("*")) {
      return true;
    }
    if (slash>=0 && slash!=noscheme.length()-1) {
      /* there's more in the URL string after the '/' */
      String URLpath = noscheme.substring(slash+1);
      if (text.startsWith("%*")) {
	if (text.equals("%*")){
	  if (!URLpath.equals("*"))
	    return false;
	}
	else if (text.endsWith("%*")) {
	  String nostar = text.substring(2, text.length()-2);
	  if (!URLpath.equals("*"+nostar+"*")) {
	    return false;
	  }
	}
	else if (text.endsWith("*")) {
	  String nostar = text.substring(2, text.length()-1);
	  if (!URLpath.startsWith("*"+nostar)) {
	    return false;
	  }
	}
	else {
	  String nostar = text.substring(2);
	  if (!URLpath.equals("*"+nostar)) {
	    return false;
	  }
	}
      }
      else if (text.startsWith("*")) {
	if (text.endsWith("%*")) {
	  String nostars = text.substring(1, text.length()-2);
	  if (!URLpath.endsWith(nostars+"*")) {
	    return false;
	  }
	}
	else if (text.endsWith("*")) {
	  String nostars = text.substring(1, text.length()-1);
	  if (URLpath.indexOf(nostars)==-1) {
	    return false;
	  }
	}
	else {
	  String nostars = text.substring(1);
	  if (!URLpath.endsWith(nostars)) {
	    return false;
	  }
	}
      }
      else {
	/* text pattern begins with something other than * or %* */
	if (text.endsWith("%*")) {
	  String nostars = text.substring(0, text.length()-2);
	  if (!URLpath.equals(nostars+"*")) {
	    return false;
	  }
	}
	else if (text.endsWith("*")) {
	  String nostars = text.substring(0, text.length()-1);
	  if (!URLpath.startsWith(nostars)) {
	    return false;
	  }
	}
	else {
	  if (!URLpath.equals(text)) {
	    return false;
	  }
	}
      }
    }
    else {
      /* the URL ends at '/' */
      if (text.equals("")){
	return true;
      }
      else {
	return false;
      }
    }
    return true;
  }

}
