/* JJT: 0.2.2 */

package w3c.pics.parser;

import java.util.Enumeration;

class PICSInternet_Node extends SimpleNode implements URLEvalNode {
  PICSInternet_Node(int id) {
    super(id);
  }

  String text = null;
  
  public String getText() {
    return text;
  }

  public boolean isValid(String URL) {
    boolean retval = true;
    int childcount = this.children.length;
    for (int count=0; count<childcount; count++) {
      URLEvalNode nextkid = (URLEvalNode) children[count];
      /*      if (nextkid instanceof PICSScheme_Node){
	System.out.println("Scheme pattern text is-- "+((PICSScheme_Node)nextkid).text+ "--");
      }
      else if (nextkid instanceof PICSUser_Node){
	System.out.println("User pattern text is-- "+((PICSUser_Node)nextkid).text+ "--");
      }
      else if (nextkid instanceof PICSHost_Node){
	System.out.println("Host pattern text is-- "+((PICSHost_Node)nextkid).text+ "--");
      }
      else if (nextkid instanceof PICSIP_Node){
	System.out.println("IP pattern text is-- "+((PICSIP_Node)nextkid).text+ "--");
      }
      else if (nextkid instanceof PICSPort_Node){
	System.out.println("Port pattern text is-- "+((PICSPort_Node)nextkid).text+ "--");
      }
      else if (nextkid instanceof PICSPath_Node){
	System.out.println("Path pattern text is-- "+((PICSPath_Node)nextkid).text+ "--");
      }
      */

      retval = nextkid.isValid(URL);
      if (!retval)
	return false;
    }
    // check to see if rule has no user but URL does
    boolean founduser = false;
    boolean foundport = false;
    for (int count=0; count<childcount; count++) {
      Node testnode = (Node)children[count];
      if (testnode instanceof PICSUser_Node) {
	founduser = true;
      }
      if (testnode instanceof PICSPort_Node) {
	foundport = true;
      }
    }
    if (!founduser) {
      int endscheme = URL.indexOf("//");
      if (endscheme==-1)
	return false;
      int atsign = URL.indexOf("@");
      if (atsign!=-1)
	return false;
    }
    // check to see if rule has no port but URL does
    if (!foundport) {
      int doubleslash = URL.indexOf("//");
      String noscheme = URL.substring(doubleslash+2);
      int colon = noscheme.indexOf(":");
      int slash = noscheme.indexOf("/");
      if (colon!=-1) {
	if (slash!=-1) {
	  if (colon<slash) {
	    return false;
	  }
	}
      }
    }
    // check to see if rule has no path but URL does
    if (!(this.children[childcount-1] instanceof PICSPath_Node)) {
      int doubleslash = URL.indexOf("//");
      String noscheme = URL.substring(doubleslash+1);
      int slash = noscheme.indexOf("/");
      if ((slash!=-1) && (slash!=noscheme.length()-1))
	return false;
    }
    /* no reason why it doesn't match, so it does match... */
    return true;
  }
}
