/* JJT: 0.2.2 */

package w3c.pics.parser;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

class PICSIP_Node extends SimpleNode implements URLEvalNode {
  PICSIP_Node(int id) {
    super(id);
  }

  String text = null;

  public String getText() {
    return text;
  }

  public boolean isValid(String URL) {
    // first lookup the IP address for the url that is supplied.
    // find the hostname
    int doubleslash = URL.indexOf("//");
    String noscheme = URL.substring(doubleslash+2);
    int colon = noscheme.indexOf(":");
    int atsign = noscheme.indexOf("@");
    int slash = noscheme.indexOf("/");
    String host = null;
    if (slash!=-1) {
      if (atsign!=-1) {
	if (colon!=-1) {
	  if (atsign<slash) {
	    if (colon<slash) {
	      host = noscheme.substring(atsign+1, colon);
	    }
	    else {
	      host = noscheme.substring(atsign+1, slash);
	    }
	  }
	  else {
	    if (colon<slash) {
	      host = noscheme.substring(0, colon);
	    }
	    else {
	      host = noscheme.substring(0, slash);
	    }
	  }
	}
	else { // no colon
	  if (atsign<slash) {
	    host = noscheme.substring(atsign+1, slash);
	  }
	  else {
	    host = noscheme.substring(0, slash);
	  }
	}
      }
      else { // no atsign
	if (colon!=-1) {
	  if (colon<slash) {
	    host = noscheme.substring(0, colon);
	  }
	  else {
	    host = noscheme.substring(0, slash);
	  }
	}
	else { // no colon or atsign
	  host = noscheme.substring(0, slash);
	}
      }
    }
    else { // no slash
      if (atsign!=-1) {
	if (colon!=-1) {
	  if (atsign>colon) {
	    host = noscheme.substring(atsign+1, colon);
	  }
	  else {
	    host = noscheme.substring(0, colon);
	  }
	}
	else { // no slash or colon 
	  host = noscheme.substring(atsign+1);
	}
      }
      else { // no slash or atsign 
	if (colon!=-1) {
	  host = noscheme.substring(0, colon);
	}
	else { // no slash or atsign or colon
	  host = noscheme;
	}
      }
    }
    // lookup from hostname
    String URLhost = null;
    try {
      InetAddress URLaddr = InetAddress.getByName(host);
      URLhost = URLaddr.getHostAddress();
    }
    catch (UnknownHostException ex) {
      return false;
    }
    if (text.indexOf("!")==-1) {
      StringTokenizer texttokenizer = new StringTokenizer(text, ".");
      StringTokenizer URLtokenizer = new StringTokenizer(URLhost, ".");
      while (texttokenizer.hasMoreTokens()) {
	String t = texttokenizer.nextToken();
	String l = URLtokenizer.nextToken();
	if (!t.equals(l))
	  return false;
      }
      return true;
    }
    else {
      int bang = text.indexOf("!");
      String bitlength = text.substring(bang+1);
      String realtext = text.substring(0, bang);
      Integer bitnum = new Integer(bitlength);
      int b = bitnum.intValue();
      StringTokenizer texttokenizer = new StringTokenizer(realtext, ".");
      StringTokenizer URLtokenizer = new StringTokenizer(URLhost, ".");
      int i = 4;
      while (texttokenizer.hasMoreTokens()) {
	String t = texttokenizer.nextToken();
	String l = URLtokenizer.nextToken();
	if (b>=(i*8)) {
	  i--;
	  continue;
	}
	if (!t.equals(l)) {
	  return false;
	}
      }
      return true;
    }
  }

}







