/* JJT: 0.2.2 */

package w3c.pics.parser;


class PICSHost_Node extends SimpleNode implements URLEvalNode {
  PICSHost_Node(int id) {
    super(id);
  }

  String text = null;

  public String getText() {
    return text;
  }


  public boolean isValid(String URL) {
    int doubleslash = URL.indexOf("//");
    String noscheme = URL.substring(doubleslash+2);
    int colon = noscheme.indexOf(":");
    int atsign = noscheme.indexOf("@");
    int slash = noscheme.indexOf("/");
    String host = null;
    if (slash!=-1) {
      if (atsign!=-1) {
	if (colon!=-1) {
	  if (atsign<slash) {
	    if (colon<slash) {
	      host = noscheme.substring(atsign+1, colon);
	    }
	    else {
	      host = noscheme.substring(atsign+1, slash);
	    }
	  }
	  else {
	    if (colon<slash) {
	      host = noscheme.substring(0, colon);
	    }
	    else {
	      host = noscheme.substring(0, slash);
	    }
	  }
	}
	else { // no colon
	  if (atsign<slash) {
	    host = noscheme.substring(atsign+1, slash);
	  }
	  else {
	    host = noscheme.substring(0, slash);
	  }
	}
      }
      else { // no atsign
	if (colon!=-1) {
	  if (colon<slash) {
	    host = noscheme.substring(0, colon);
	  }
	  else {
	    host = noscheme.substring(0, slash);
	  }
	}
	else { // no colon or atsign
	  host = noscheme.substring(0, slash);
	}
      }
    }
    else { // no slash
      if (atsign!=-1) {
	if (colon!=-1) {
	  if (atsign>colon) {
	    host = noscheme.substring(atsign+1, colon);
	  }
	  else {
	    host = noscheme.substring(0, colon);
	  }
	}
	else { // no slash or colon 
	  host = noscheme.substring(atsign+1);
	}
      }
      else { // no slash or atsign 
	if (colon!=-1) {
	  host = noscheme.substring(0, colon);
	}
	else { // no slash or atsign or colon
	  host = noscheme;
	}
      }
    }
    // compare host with text
    // System.out.println("text is-- "+text+ "--");
    if (text.startsWith("%*")) {
      String nostar = text.substring(2);
      if (!host.equals("*"+nostar)) {
	//	System.out.println("host is-- "+host+" --pattern host is-- " + text + "--");
	return false;
      }
    }
    else if (text.startsWith("*")) {
      String nostar = text.substring(1);
      if (!host.endsWith(nostar)) {
	return false;
      }
    }
    else {
      if (!host.equals(text)) {
	return false;
      }
    }
    return true;
  }


}
