package w3c.pics.parser;

/**
 * Contains the results of evaluating a label against a profile (a boolean 
 * and an explanation).
 **/

public class EvalResult
{
  boolean result;
  String explanation;

  /**
   * Create a new EvalResult.
   * @param result The boolean value.
   * @param explanation The explanation.
   **/

  public EvalResult (boolean result, String explanation){
    this.result = result;
    this.explanation = explanation;
  } 

  /**
   * Returns the boolean portion of the EvalResult.
   * @return A boolean.
   **/

  public boolean getResult(){
    return result;
  }

  /**
   * Returns the String portion of the EvalResult.
   * @return A String (the explanation).
   **/

  public String getExplanation(){
    return explanation;
  }
}
