// Enum.java

package w3c.pics.parser;

/**
 * Enum represents an enumerated value from a PICS service description.  
 * Enumerated values are the labeled values that can appear in a category 
 * description.
 **/

public class Enum implements java.io.Serializable {

  String name = null;
  String value = null;
  String desc = null;
  String icon = null;

  /**
   * Creates a new Enum.
   * @param ename The name for the Enum.
   * @param evalue The value.
   **/

  public Enum(String ename, String evalue) {
    name = ename;
    value = evalue;
  }

  /**
   * Sets the icon attribute for this Enum.
   * @param icondef The new icon attribute value.
   **/

  public void setIcon(String icondef) {
    icon = icondef;
  }

  /**
   * Sets the description attribute for this Enum.
   * @param description The new description attribute value.
   **/

  public void setDesc(String description) {
    desc = description;
  }

  /**
   * Returns the value of this Enum.
   * @return The value of this Enum as a String.
   **/

  public String getValue() {
    return value;
  }

  /**
   * Returns the name of this Enum.
   * @return The name of this Enum.
   **/

  public String getName() {
    return name;
  }

  /**
   * Returns a String containing the attributes of this Enum, in PICS 1.1 
   * format, suitable for including in a category description of a .rat file.
   * @return A String containing the PICS 1.1 representation of this Enum.
   **/

  public String toString() {
    String retval = new String("");
    retval+="(label (name ";
    retval+=name;
    retval+=")";
    if (desc!=null) {
      retval+=" (description ";
      retval+=desc;
      retval+=")";
    }
    retval+=" (value ";
    retval+=value;
    retval+=")";
    if (icon!=null) {
      retval+=" (icon ";
      retval+=icon;
      retval+=")";
    }
    retval+=")\n";
    return retval;
  }
}
