// SigSuiteRSASHA1.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.crypto.us.dsig;

import java.util.*;
import java.math.BigInteger;
import java.security.*;
import java.security.interfaces.*;

import w3c.tools.codec.*;
import COM.rsa.jsafe.*;

/**
 * This class implements the RSA/SHA1 signature suite for the W3C's DSig
 * as defined in <TT>http://www.w3.org/PICS/DSig/RSA-SHA1-1_0.html</TT>.
 * <P>
 * Application programmers should never access this class via its name
 * <CODE>w3c.www.dsig.SigSuiteRSASHA1</CODE>. You should use
 * <CODE>SigSuiteRegistry.getInstance()</CODE>,
 * <CODE>sigblock.getSigSuite()</CODE>, etc.
 * <P>
 * This class does not the implement the cryptographic RSA algorithm itself,
 * it requires that RSA Security Inc. JSAFE package (COM.rsa.jsafe) to
 * present in order to run this class correctly.
 * <P>
 *
 * @author Mark Champine
 * @see     w3c.crypto.us.dsig.SigSuiteRSA
 * @version 1.0 (last modified 10-February-1998)
 */

public class SigSuiteRSASHA1 extends SigSuiteRSA {

  private final static boolean DEBUG = false;

  private static MessageDigest sha1;

  /**
   * The string defined to indentify the RSA/SHA1
   * signature suite implemented by this class,
   * <TT>http://www.w3.org/PICS/DSig/RSA-SHA1-1_0.html</TT>.
   */
  public final static String
  RSASHA1URL = "http://www.w3.org/PICS/DSig/RSA-SHA1-1_0.html";

  private static Class sha1provider = null;

  static {
    initialize();
  }

  /**
   * Initialize function that makes sure that provider implementing
   * DSS is present and stores the Class object of that class.
   */
  private static void initialize()
  {
    if( sha1provider == null ) {
      try {
        sha1 = MessageDigest.getInstance("SHA-1");
        sha1provider = sha1.getClass();
        if (DEBUG) 
	  System.out.println("SigSuiteRSASHA1: Using SHA1 implementation from " 
			     + sha1provider.getName());
      } catch( NoSuchAlgorithmException e ) {
        if(DEBUG) System.err.println("Could not find algorithm SHA1!");
      }
    }
  }


  /**
   * Constructor for use by
   * <CODE>w3c.www.dsig.SigSuiteRegistry.getInstance()</CODE>.
   * Application programmers should not need to access this
   * constructor directly.
   * @exception NoSuchAlgorithmException if the algorithm cannot
   * be initialized.
   */
  public SigSuiteRSASHA1 () throws NoSuchAlgorithmException
  {
    super(RSASHA1URL, "RSASHA1", sha1);
    if( sha1provider == null ) throw new NoSuchAlgorithmException();
  }
}

