// SigSuiteRSAMD5.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.crypto.us.dsig;

import java.util.*;
import java.math.BigInteger;
import java.security.*;
import java.security.interfaces.*;

import w3c.tools.codec.*;
import COM.rsa.jsafe.*;

/**
 * This class implements the RSA/MD5 signature suite for the W3C's DSig
 * as defined in <TT>http://www.w3.org/TR/1998/REC-DSig-label/RSA-MD5-1_0</TT>.
 * <P>
 * Application programmers should never access this class via its name
 * <CODE>w3c.www.dsig.SigSuiteRSAMD5</CODE>. You should use
 * <CODE>SigSuiteRegistry.getInstance()</CODE>,
 * <CODE>sigblock.getSigSuite()</CODE>, etc.
 * <P>
 * This class does not the implement the cryptographic RSA algorithm itself,
 * it requires that RSA Security Inc. JSAFE package (COM.rsa.jsafe) to
 * present in order to run this class correctly.
 * <P>
 *
 * @author Mark Champine
 * @see     w3c.crypto.us.dsig.SigSuiteRSA
 * @version 1.0 (last modified 10-February-1998)
 */

public class SigSuiteRSAMD5 extends SigSuiteRSA {

  private final static boolean DEBUG = false;

  private static MessageDigest md5;

  private static Class md5provider = null;

  /**
   * The string defined to indentify the RSA/MD5
   * signature suite implemented by this class,
   * <TT>http://www.w3.org/TR/1998/REC-DSig-label/RSA-MD5-1_0</TT>.
   */
  public final static String
  RSAMD5URL = "http://www.w3.org/TR/1998/REC-DSig-label/RSA-MD5-1_0";

  static {
    initialize();
  }

  /**
   * Initialize function that makes sure that provider implementing
   * RSA and MD5 are present and stores the Class object of that class.
   */
  private static void initialize()
  {
    if( md5provider == null ) {
      try {
        md5 = MessageDigest.getInstance("MD5");
        md5provider = md5.getClass();
        if (DEBUG) 
	  System.out.println("SigSuiteRSAMD5: Using MD5 implementation from " 
			     + md5provider.getName());
      } catch( NoSuchAlgorithmException e ) {
        if(DEBUG) System.err.println("Could not find algorithm MD5!");
      }
    }
  }


  /**
   * Constructor for use by
   * <CODE>w3c.www.dsig.SigSuiteRegistry.getInstance()</CODE>.
   * Application programmers should not need to access this
   * constructor directly.
   * @exception NoSuchAlgorithmException if the algorithm cannot
   * be initialized.
   */
  public SigSuiteRSAMD5 () throws NoSuchAlgorithmException
  {
    super(RSAMD5URL, "RSAMD5", md5);
    if( md5provider == null ) throw new NoSuchAlgorithmException();
  }
}

