/*
 * @(#)decrypt.java	1.1 97/05/02 
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.io.*;
import java.security.*;

/**
 * Decrypt the file named by "secret.txt" using the
 * DES key contained in the file "keyfile."
 * This is a companion demo program to the encrypt.java program.
 * 
 * @author Marianne Mueller, Vijay Srinivasan
 */

class decrypt {
    public static void main(String args[]) {

	Key desKey;
	ObjectInputStream keyfile;

	Cipher cipher;
	CipherInputStream cis;

	FileInputStream fis;
	FileOutputStream fos;

	byte[] in = new byte[5000];
	int length; 

	try { 

	    keyfile = new ObjectInputStream(new FileInputStream("keyfile"));
	    desKey = (SecretKey)keyfile.readObject();

	    cipher = Cipher.getInstance("DES/ECB/PKCS#5");
	    cipher.initDecrypt(desKey);

	    fis = new FileInputStream("secret.txt");
	    fos = new FileOutputStream("unsecret.txt");

	    cis = new CipherInputStream(fis, cipher);
	    length = cis.read(in, 0, in.length);
	    fos.write(in, 0, length);
	    fos.close();
	    cis.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}



