/*
 *  UserOptionValue.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: UserOptionValue.java,v 1.1 1997/04/15 20:39:35 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Vector;
import w3c.tools.sexpr.Symbol;
import java.io.PrintStream;
import java.net.*;

public class UserOptionValue {

  private boolean optional = false;
  private Object data[] = {};
  private String identifier;

  public UserOptionValue()
  {
  }

  public UserOptionValue(Vector parsedData)
    throws PICSParserException
  {
    Symbol key = (Symbol)parsedData.elementAt(0);
    if (key == PICS.OPTIONAL)
      this.optional = true;
    else if (key == PICS.MANDATORY)
      this.optional = false;
    else
      throw new 
	PICSParserException("Extension must be optional or mandatory: " + key);
    identifier = ((String)parsedData.elementAt(1));

    this.data = new Object[parsedData.size() - 2];
    for (int i = 2; i < parsedData.size(); i++)
      data[i - 2] = parsedData.elementAt(i);
  }


  public boolean isOptional()
  {
    return optional;
  }

  public boolean isMandatory()
  {
    return (! optional);
  }

  public Object[] getData()
  {
    return data;
  }

  // yc-a
  public Vector getVectorData()
  {
    Vector v = new Vector();
    for (int i=0; i<data.length; i++) 
      v.addElement(data[i]);
    return v;
  }

  public void setData(Object data[])
  {
    this.data = data;
  }
  

  public static Object[] vectorToDataArray(Vector v)
  {
    Vector data[] = new Vector[v.size()];
    for (int i=0; i<v.size(); i++) 
      data[i] = (Vector) v.elementAt(i);
    return data;
  }    

  public void setVectorData(Vector v)
  {
    this.data = vectorToDataArray(v);
  }
  
  public void setMandatory()
  {
    optional = false;
  }

  public void setOptional()
  {
    optional = true;
  }


  public void setURL(String url)
  {
    identifier=url;
  }


  public String getURL()
  {
    return identifier;
  }


  public void prinExpr(PrintStream out)
  {
    out.print(toString());
  }


  public String toString()
  {
    Vector option = new Vector();
    if (optional)
      option.addElement(PICS.OPTIONAL);
    else
      option.addElement(PICS.MANDATORY);
    option.addElement(identifier);
    for (int i=0; i<data.length; i++)
      option.addElement(data[i]);
    return PICSStream.toString(option);
  }
}
