/*
 *  SymbolToBoolean.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: SymbolToBoolean.java,v 1.1 1997/04/15 20:39:34 yhchu Exp $
 */

package w3c.www.pics;

public class SymbolToBoolean implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    if (value == PICS.TRUE || value == PICS.TRUE_ABBR)
      return Boolean.TRUE;
    else if (value == PICS.FALSE || value == PICS.FALSE_ABBR)
      return Boolean.FALSE;
    else
      throw new PICSParserException("Illegal boolean value " + value);
  }

}
