/*
 *  StringToDate.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  rewritten by Andreas Sterbenz (14-oct-1997)
 *
 *  $Id: StringToDate.java,v 1.1 1997/04/15 20:39:32 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Date;

import w3c.www.pics.ISODate;

public class StringToDate implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    try {
      return new ISODate((String)value);
    }
    catch (NumberFormatException e) {
      System.out.println("de");
      e.printStackTrace();
      throw new PICSParserException("Unable to parse ISO date", e);
    }
  }
}
