/*
 *  PushbackEnumeration.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PushbackEnumeration.java,v 1.1 1997/04/15 20:39:30 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Enumeration;

public class PushbackEnumeration implements Enumeration {

  private Enumeration source;
  private boolean pushedBack;
  private Object next;

  public PushbackEnumeration(Enumeration source)
  {
    this.source = source;
    this.pushedBack = false;
  }

  public boolean hasMoreElements()
  {
    return pushedBack || source.hasMoreElements();
  }

  public Object nextElement()
  {
    if (pushedBack) {
      pushedBack = false;
      return next;
    }
    else return source.nextElement();
  }

  public Object peekElement()
  {
    if (!pushedBack) {
      pushedBack = true;
      next = source.nextElement();
    }
    return next;
  }

  public void push(Object element)
  {
    next = element;
    pushedBack = true;
  }

}
