/*
 *  PropertySet.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PropertySet.java,v 1.1 1997/04/15 20:39:29 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Dictionary;
import java.util.Hashtable;
import w3c.tools.sexpr.Symbol;
 
public class PropertySet extends Hashtable {

  private Dictionary defaults;

  public PropertySet(Dictionary defaults)
  {
    super();
    this.defaults = defaults;
  }

  public Object putWithMap(Object key, Object value, Dictionary mappers)
    throws PICSParserException
  {
    Object m;
    if (mappers == null)
      return put(key, value);
    else if ((m = mappers.get(key)) instanceof Mapper)
      return put(key, ((Mapper)m).map(value));
    else if (m instanceof Symbol)
      // if the "mapper" for a key is a Symbol, use that Symbol as the key
      return putWithMap(m, value, mappers);
    else
      return put(key, value);
  }

  public Object get(Object key)
  {
    Object value = super.get(key);
    if (value != null)
      return value;
    else if (defaults != null)
      return defaults.get(key);
    else
      return null;
  }

}
