/*
 *  PICSStream.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  Andreas Sterbenz: handling of Boolean added
 *
 *  $Id: PICSStream.java,v 1.1 1997/04/15 20:39:28 yhchu Exp $
 */

package w3c.www.pics;

import w3c.tools.sexpr.*;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.io.IOException;
import java.io.EOFException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import java.net.URL;
import java.util.Date;
import w3c.www.dsig.*;

/**
 * Basic implementation of the SExprStream parser interface.
 */
public class PICSStream extends SimpleSExprStream implements SExprStream {

  public PICSStream (InputStream input)
  {
    super(input);
  }

  /**
   * Produces a printed representation of an s-expression.
   */
  public static void printExpr(Object expr, PrintStream out)
  {
    out.print(toString(expr));
  }


  /**
   * Produces a string representation of an s-expression.
   */
  public static String toString(Object expr)
  {
    if (expr == null)
      return "";
    if (expr instanceof Number ||
	expr instanceof UserOptionValue ||
	expr instanceof RatingValue ||
	expr instanceof PICSExtension ||
	expr instanceof SExpr)
      return expr.toString();

    if (expr instanceof URL ||
	expr instanceof Date ||
	expr instanceof ISODate)
      return "\"" + expr.toString() + "\"";

    if (expr instanceof String)
      return "\"" + (String)expr + "\"";

    if (expr instanceof Vector) {
      String s = "(";
      for (int i=0; i < ((Vector)expr).size(); i++)
        s += " " + PICSStream.toString(((Vector)expr).elementAt(i));
      return s += " )";
    }
    
    // Andreas Sterbenz: addition
    if ( expr instanceof Boolean ) {
      if (expr.toString().equals("true"))
	return "t"; 
      else 
	return "f";
    }

    // error
    return "<#unknown " + expr.getClass().getName() + ":" + expr.toString() + ">)";
  }

  /**
   * Produces a normative form of the string representation of
   * an s-expression.
   */
  public String toNormativeForm(Object v)
  {
    return toString(v);
  }



  public static void main(String args[])
    throws SExprParserException, IOException
  {
    SExprStream p = new PICSStream(System.in);
    Object e = p.parse();
    PICSStream.printExpr(e, System.out);
    System.out.println(PICSStream.toString(e));
    System.out.println();
  }

}
