/*
 *  PICS.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: PICS.java,v 1.1 1997/04/15 20:39:25 yhchu Exp $
 */

package w3c.www.pics;

import java.util.Hashtable;
import w3c.tools.sexpr.Symbol;

public class PICS {

  private static Hashtable symbols = new Hashtable();

  // option labels
  public static final Symbol AT        = sym("at",                symbols);
  public static final Symbol MD5       = sym("md5",               symbols);
  public static final Symbol BY        = sym("by",                symbols);
  public static final Symbol FOR       = sym("for",               symbols);
  public static final Symbol GEN       = sym("gen",               symbols);
  public static final Symbol ON        = sym("on",                symbols);
  public static final Symbol SIGNATURE = sym("signature-RSA-MD5", symbols);
  public static final Symbol EXP       = sym("exp",               symbols);
  public static final Symbol COMMENT   = sym("comment",           symbols);
  public static final Symbol FULL      = sym("full",              symbols);

  // other labels
  public static final Symbol EXTENSION = sym("extension",         symbols);
  public static final Symbol VERS_1_1  = sym("pics-1.1",          symbols);
  public static final Symbol LABELS    = sym("l",                 symbols);
  public static final Symbol RATINGS   = sym("r",                 symbols);
  public static final Symbol OPTIONAL  = sym("optional",          symbols);
  public static final Symbol MANDATORY = sym("mandatory",         symbols);
  public static final Symbol TRUE      = sym("t",                 symbols);
  public static final Symbol FALSE     = sym("f",                 symbols);

  // synonyms
  public static final Symbol MD5_ABBR     = sym("mic-md5",        symbols);
  public static final Symbol GEN_ABBR     = sym("generic",        symbols);
  public static final Symbol EXP_ABBR     = sym("until",          symbols);
  public static final Symbol FULL_ABBR    = sym("complete-label", symbols);
  public static final Symbol LABELS_ABBR  = sym("labels",         symbols);
  public static final Symbol RATINGS_ABBR = sym("ratings",        symbols);
  public static final Symbol TRUE_ABBR    = sym("true",           symbols);
  public static final Symbol FALSE_ABBR   = sym("false",          symbols);

  public static Hashtable getSymbols()
  {
    return symbols;
  }

  private static Symbol sym(String name, Hashtable st)
  {
    return Symbol.makeSymbol(name, st);
  }

}
