// PubKey.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;
import w3c.www.dsig.*;

import java.security.*;

public class PubKey implements java.security.PublicKey
{
    public byte[] x;
    public byte[] y;

    public PubKey (byte[] x, byte[] y)
    {
        this.x = x;
        this.y = y;
    }

    public String getAlgorithm() { return "ECC"; }
    public String getFormat() { return "hex";}
    public byte[] getEncoded() { return x;}  //don't use


}
