// DSigException.java.java
// $Id: DSigException.java.java,v 1.1 1997/04/15 20:39:14 yhchu Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;

/**
 * Generic exception for DSig.
 */
public class DSigException extends Exception {

  public DSigException() {
    super("Error in DSig Library");
  }

  public DSigException(String msg) {
    super(msg);
  }

  public DSigException(Object cls, String found, String expect,
			   String msg)
  {
    super(cls.getClass().getName() + " Error: " + msg + "\"" +
	  "   found " + found + ", expect " + expect + "\n");
  }
}
