// DSAPrivateClass.java
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

// The source code is jointly developed by W3C and some of its members
// participating in the Digital Signature Initiative.  The authors are:
//    Mark Champine, HP, <champine@apollo.hp.com>
//    Yang-hua Chu, MIT/W3C, <yhchu@w3.org>
//    Vasanthan Dasan, Sun, <vasanthan.dasan@central.sun.com>
//    Peter Lipp, University of Technology, Graz <plipp@iaik.tu-graz.ac.at>
//    Andreas Sterbenz, U. of Technology, Graz <sterbenz@iaik.tu-graz.ac.at>

package w3c.www.dsig;

import java.math.BigInteger;
import java.security.interfaces.*;
import w3c.www.dsig.DSAParamsClass;

/**
 * An implementation of the <CODE>java.security.interfaces.DSAPrivateKey</CODE>
 * interface. This was written because generating a DSA private key
 * from given parameters using the JDK implementation in the Sun
 * provider is not possible by via the security interfaces (BUG!).
 *
 * @author Andreas Sterbenz
 * @version 1.0 (last modified 17-oct-1997)
 */
public class DSAPrivateKeyClass implements DSAPrivateKey
{
  private BigInteger x;
  private DSAParams dsaParams;

  /**
   * Create a new DSA private key from the given x and the parameters
   * dsaparams.
   */
  public DSAPrivateKeyClass(BigInteger x, DSAParams dsaParams)
  {
    this.x = x;
    this.dsaParams = dsaParams;
  }

  /**
   * Create a new DSA private key from the given BigInteger values.
   */
  public DSAPrivateKeyClass(BigInteger x, BigInteger p, BigInteger q, BigInteger g)
  {
    this.x = x;
    this.dsaParams = new DSAParamsClass(p, q, g);
  }

  /**
   * Return a new DSA private key from the given x and the parameters
   * dsaparams. This is equivalent to using the constructor with new()
   * except that this method could be declared in an interface (which
   * it currently is not) while constructors cannot.
   */
  public static DSAPrivateKeyClass newDSAPrivateKeyClass(BigInteger x, DSAParams dsaParams)
  {
    return new DSAPrivateKeyClass(x, dsaParams);
  }

  /**
   * Return a new DSA private key from the given BigInteger values.
   * This is equivalent to using the constructor with new()
   * except that this method could be declared in an interface (which
   * it currently is not) while constructors cannot.
   */
  public static DSAPrivateKeyClass newDSAPrivateKeyClass(BigInteger x, BigInteger p, BigInteger q, BigInteger g)
  {
    return new DSAPrivateKeyClass(x, p, q, g);
  }

  public BigInteger getX()
  {
    return this.x;
  }

  public DSAParams getParams()
  {
    return this.dsaParams;
  }

  /**
   * Returns the String "DSA"
   */
  public String getAlgorithm()
  {
    return "DSA";
  }

  /**
   * Get the format of the encoding, as encoding is not supported
   * this returns null.
   */
  public String getFormat()
  {
    return null;
  }

  /**
   * Get the encoding, as encoding is not supported
   * this returns null.
   */
  public byte[] getEncoded()
  {
    return null;
  }
}
