package w3c.pics.parser;

import java.io.*;
import java.util.*;

/**
 * Parse a file with one URL per line.
 **/

class URLInput extends BufferedReader
{
  public URLInput(String fileName) throws IOException{
    super(new FileReader(fileName));
  }

  public String getNextURL() throws IOException{
    return readLine();
  }

  public Vector getAllURLs() throws IOException{
    Vector result = new Vector();
    int i=0;
    String url;
    while ((url = getNextURL()) != null){
      result.addElement(url);
    }
    return result;
  }
}





