package w3c.pics.parser;

/**
 * A helper class to decode the hex-encoded Strings that can be found in 
 * PICSRules profiles.
 **/

public class ProfileDecoder {

  /**
   * Decodes all hex encodings from the input String.
   * @param input The String to decode.
   * @return A String that contains no hex encodings.
   **/

  public static String decode(String input) {
    if (input.indexOf("%")==-1) 
      return input;
    else {
      int percent = input.indexOf("%");
      String hex = input.substring(percent, percent+3);
      if (hex.equals("%22")) {
	String pre = input.substring(0, percent);
	pre+="\"";
	pre+=input.substring(percent+3);
	return decode(pre);
      }
      else if (hex.equals("%27")) {
	String pre = input.substring(0, percent);
	pre+="'";
	pre+=input.substring(percent+3);
	return decode(pre);
      }
      else if (hex.equals("%25")) {
	String pre = input.substring(0, percent+1);
	String post = input.substring(percent+3);
	return pre+decode(post);
      }
      else {
	return "Invalid hex encoding in String";
      }
    }
  }
}
