// PICSParser.java
// Version 1.2.1		5/20/98

package w3c.pics.parser;

import java.io.*;
import java.util.*;

public class PICSParser {

  public static void main(String args[]) {

    String cmd = null;
    if (args.length!=0) {
      if (args[0].equals("-debug")) {
	Globals.debugmode = true;
	System.out.println("Debug Mode");
      }
    }
    System.out.println("Type \"help\" for a list of available commands");
    do {
      BufferedReader cmdreader = 
	new BufferedReader(new InputStreamReader(System.in));
      System.out.println("command: ");
      try {
	cmd = cmdreader.readLine();
      }
      catch (IOException e) {
	System.out.println("command: I/O Error");
	break;
      }
      if (cmd==null)
	break;
      if ((cmd.equals("help")) || (cmd.equals("?"))) {
	System.out.println("");
	System.out.println("Available Commands:");
	System.out.println("testsuite <URLfile> <profile>: Checks each URL "+
			   "in <URLfile> against \n<profile>, "+
			   "requesting labels from a label bureau as " +
			   "specified in <profile>. Currently not \n"+
			   "checking for embedded labels even if <profile> " +
			   "specifies that.");
	System.out.println("filter <htmlfile> <profile>: Filters the HTML "+
			   "in <htmlfile> according to \nthe labels in its "+
			   "header and the profile in <profile>");
	System.out.println("find labels <filename>: parses the HTML file "+
			   "<filename>, looking for labels \nin its header.");
	System.out.println("parse dsiglabel <filename>: parses the label(s) "+
			   "contained in the file \n<filename> and outputs "+
			   "in Dsig-ready canonicalized form.");
	System.out.println("parse label <filename>: parses the label(s) "+
			   "contained in the file <filename>");
	System.out.println("parse profile <filename>: parses the profile "+
			   "contained in the file <filename>");
	System.out.println("parse service <filename>: parses the service "+
			   "contained in the file <filename>");
	System.out.println("process <labelfile> <profile>: Runs the label(s) "+
			   "from <labelfile> against \nthe profile in "+
			   "<profile>");
	System.out.println("quit: Quits the program");
      }
      else if (cmd.equals("quit")) {
	System.exit(0);
      }
      else if (cmd.startsWith("find labels")) {
	int lastspace = cmd.lastIndexOf(" ");
	String filename = cmd.substring(lastspace+1);
	LabelFinder lf = new LabelFinder(filename);
	int lfcount = lf.getLabels();
	System.out.println("Number of labels: "+lfcount);
	for (int l = 0; l<lfcount; l++) {
	  System.out.println("Label "+l+":");
	  System.out.println(lf.showLabel(l));
	}
      }
      else if (cmd.startsWith("testsuite")) {
	int firstspace = cmd.indexOf(" ");
	int lastspace = cmd.lastIndexOf(" ");
	String urlfile = cmd.substring(firstspace+1, lastspace);
	String pfile = cmd.substring(lastspace+1);
	try {
	  /* first read and parse the profile (PICSRule) from a file */
	  FileInputStream pinput = new FileInputStream(pfile);
	  if (Globals.firstprofile) {
	    Globals.pparser = new ProfileParser(pinput);
	    Globals.firstprofile = false;
	  }
	  else
	    Globals.pparser.ReInit(pinput);
	  Profile prof = new Profile();
	  Globals.pparser.rule(prof);
	  pinput.close();
	  /* now read in all the URLs */
	  Vector URLs = new URLInput(urlfile).getAllURLs();
	  /* check each URL against the rule; label bureau fetches
	  /* will be done automatically as part of the check, if
	  /* needed */
	  Vector results = prof.checkAll(URLs);
	  /* if desired, print out the results to system.out */
	  prof.printResults(URLs, results);
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	  if (e.getMessage()!=null)
	    System.out.println(e.getMessage());
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error");
	  if (ex.getMessage()!=null)
	    System.out.println(ex.getMessage());
	}
      }
      else if (cmd.startsWith("filter")) {
	int firstspace = cmd.indexOf(" ");
	int lastspace = cmd.lastIndexOf(" ");
	String htmlfile = cmd.substring(firstspace+1, lastspace);
	String pfile = cmd.substring(lastspace+1);
	try {
	  Vector labels = new Vector();
	  LabelFinder lf = new LabelFinder(htmlfile);
	  for (int l = 0; l<lf.getLabels(); l++) {
	    StringBufferInputStream lflabel = 
	      new StringBufferInputStream(lf.showLabel(l));
	    if (Globals.firstlabel) {
	      Globals.lparser = new LabelParser(lflabel);
	      Globals.firstlabel = false;
	    }
	    else
	      Globals.lparser.ReInit(lflabel);
	    Globals.lparser.labellist(labels);
	  }
	  FileInputStream pinput = new FileInputStream(pfile);
	  if (Globals.firstprofile) {
	    Globals.pparser = new ProfileParser(pinput);
	    Globals.firstprofile = false;
	  }
	  else
	    Globals.pparser.ReInit(pinput);
	  Profile prof = new Profile();
	  Globals.pparser.rule(prof);
	  // ((SimpleNode)pparser.jjtree.rootNode()).dump(">");
	  Label label1 = (Label) labels.firstElement();
	  String URL = label1.getOption("for");
	  if (Globals.debugmode) 
	    System.out.println("URL is " + URL);
	  EvalResult resultvector = prof.isValidWithReason(URL, labels, 
							   Globals.debugmode);
	  Boolean rbool = new Boolean (resultvector.getResult());
	  String rreason = (String)resultvector.getExplanation();
	  System.out.println("Result: "+rbool.toString());
	  if (rreason.equals(""))
	    System.out.println("Explanation: None Given");
	  else
	    System.out.println("Explanation: "+ProfileDecoder.decode(rreason));
	  pinput.close();
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }	  
      else if (cmd.startsWith("process")) {
	int firstspace = cmd.indexOf(" ");
	int lastspace = cmd.lastIndexOf(" ");
	String labelfile = cmd.substring(firstspace+1, lastspace);
	String pfile = cmd.substring(lastspace+1);
	try {
	  FileInputStream linput = new FileInputStream(labelfile);
	  FileInputStream pinput = new FileInputStream(pfile);
	  if (Globals.firstlabel) {
	    Globals.lparser = new LabelParser(linput);
	    Globals.firstlabel = false;
	  }
	  else
	    Globals.lparser.ReInit(linput);
	  if (Globals.firstprofile) {
	    Globals.pparser = new ProfileParser(pinput);
	    Globals.firstprofile = false;
	  }
	  else
	    Globals.pparser.ReInit(pinput);
	  Vector labels = new Vector();
	  Globals.lparser.labellist(labels);
	  Profile prof = new Profile();
	  Globals.pparser.rule(prof);
	  // ((SimpleNode)pparser.jjtree.rootNode()).dump(">");
	  Enumeration llist = labels.elements();
	  int i = 1;
	  while (llist.hasMoreElements()) {
	    Label currentLabel = (Label)llist.nextElement();
	    System.out.println("Result: Label"+i+" "+
			       prof.isValid(currentLabel.getOption("for"), 
					    currentLabel, 
					    Globals.debugmode)+"\n");
	    i++;
	  }
	  linput.close();
	  pinput.close();
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }	  
      else if (cmd.startsWith("parse label")) {
	int lastspace = cmd.lastIndexOf(" ");
	String filename = cmd.substring(lastspace+1);
	try {
	  FileInputStream input = new FileInputStream(filename);
	  if (Globals.firstlabel) {
	    Globals.lparser = new LabelParser(input);
	    Globals.firstlabel = false;
	  }
	  else
	    Globals.lparser.ReInit(input);
	  Vector labels = new Vector();
	  Globals.lparser.labellist(labels);
	  Enumeration labelenum = labels.elements();
	  while (labelenum.hasMoreElements()) {
	    System.out.println(labelenum.nextElement().toString());
	  }
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }
      else if (cmd.startsWith("parse dsiglabel")) {
	int lastspace = cmd.lastIndexOf(" ");
	String filename = cmd.substring(lastspace+1);
	try {
	  FileInputStream input = new FileInputStream(filename);
	  if (Globals.firstlabel) {
	    Globals.lparser = new LabelParser(input);
	    Globals.firstlabel = false;
	  }
	  else
	    Globals.lparser.ReInit(input);
	  Vector labels = new Vector();
	  Globals.lparser.labellist(labels);
	  Enumeration labelenum = labels.elements();
	  while (labelenum.hasMoreElements()) {
	    System.out.println(((Label)labelenum.nextElement())
			       .toDSigString());
	  }
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }
      else if (cmd.startsWith("parse profile")) {
	int lastspace = cmd.lastIndexOf(" ");
	String filename = cmd.substring(lastspace+1);
	try {
	  FileInputStream input = new FileInputStream(filename);
	  if (Globals.firstprofile) {
	    Globals.pparser = new ProfileParser(input);
	    Globals.firstprofile = false;
	  }
	  else
	    Globals.pparser.ReInit(input);
	  Profile prof = new Profile();
	  Globals.pparser.rule(prof);
	  // ((SimpleNode)pparser.jjtree.rootNode()).dump(">");
	  System.out.println(prof);
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }
      else if (cmd.startsWith("parse service")) {
	int lastspace = cmd.lastIndexOf(" ");
	String filename = cmd.substring(lastspace+1);
	try {
	  FileInputStream input = new FileInputStream(filename);
	  if (Globals.firstservice) {
	    Globals.sparser = new ServiceParser(input);
	    Globals.firstservice = false;
	  }
	  else
	    Globals.sparser.ReInit(input);
	  Service serv = new Service();
	  Globals.sparser.service_desc(serv);
	  System.out.println(serv);
	}
	catch (IOException e) {
	  System.out.println("I/O Error");
	}
	catch (ParseException ex) {
	  System.out.println("Parsing Error: "+ex.getMessage());
	}
      }
      else {
	System.out.println("Bad Command -- Type \"help\" for a list of "+
			   "available commands");
      }
    } while (cmd!=null);
    
  }



}
