// ExtendedCommonLogger.java
// $Id: ExtendedCommonLogger.java,v 1.12 2001/02/14 17:44:27 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1999.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.http ;

import java.net.URL;

import java.util.Date ;

import org.w3c.jigsaw.auth.AuthFilter;

/**
 * The ExtendedCommonLogger class implements the abstract Logger class.
 * It just rotates the log every month and use the extended log format
 * @see org.w3c.jigsaw.http.CommonLogger
 */

public class ExtendedCommonLogger extends CommonLogger {

    private   byte                 msgbuf[] = null ;

    /**
     * Log the given HTTP transaction.
     * This is shamelessly slow.
     */

    public void log (Request request, Reply reply, int nbytes, long duration) {
	Client client = request.getClient() ;
	String entry  = null ;
	long   date   = reply.getDate();
	// Compute the time zone offset, first call only.
	if ( tz == -1 ) {
	    tz = new Date().getTimezoneOffset();
	}
	Date   now;
	if (date < 0 ) {
	    now = new Date((new Date()).getTime() + tz*60*1000);
	} else {
	    now = new Date(date + (tz*60*1000));
	}
        // check if we need to reset the timezone
	if (hour == -1) {
	    hour = now.getHours();
	} else {
	    int nhour = now.getHours();
	    if (nhour != hour) {
		hour = nhour;
		tz = -1;
	    }
	}
	if (rotateLevel > 0) {
	    checkLogFile(now);
	}

	String user = (String) request.getState(AuthFilter.STATE_AUTHUSER);
	URL urlst = (URL) request.getState(Request.ORIG_URL_STATE);
	String requrl;
	if (urlst == null) {
	    requrl = request.getURL().toExternalForm();
	} else {
	    requrl = urlst.toExternalForm();
	}
	entry = client.getInetAddress().getHostAddress()
	    + " " + "-"			  	   // user name
	    + " " + ((user == null ) ? "-" : user) // auth user name
	    + ((now.getDate() < 10) ? " [0" : " [")
	    + (now.getDate() 		   	   // current date
	       + "/" + monthnames[now.getMonth()]
	       + "/" + (now.getYear() + 1900)
	       + ((hour < 10)
		  ? (":0" + hour)
		  : (":" + hour))
	       + ((now.getMinutes() < 10)
		  ? (":0" + now.getMinutes())
		  : (":" + now.getMinutes()))
	       + ((now.getSeconds() < 10)
		  ? (":0" + now.getSeconds())
		  : (":" + now.getSeconds()))
	       + " +0000]")  // we always use GMT because of some old jdk...
	    + " \"" + request.getMethod()	// request line
	    + " " + requrl
	    + " " + request.getVersion()
	    + "\" " + reply.getStatus()		// reply status
	    + " " + ((nbytes < 0 ) ? "-" :
		     Integer.toString(nbytes)) // # of emited bytes
	    + " \"" + 
	    ((request.getReferer() == null) ? "-" : request.getReferer())
	    + "\"" // the referer (ext log)
	    + " \"" + 
	    ((request.getUserAgent() == null) ? "-" : request.getUserAgent())
	    + "\"" // User agent
	    + "\n" ;
	logmsg (entry) ;
    }

    /**
     * Construct a new Logger instance.
     */

    ExtendedCommonLogger () {
	this.msgbuf = new byte[128] ;
    }   

}
