/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ControlServerHelper;
import org.w3c.jigadmin.editors.ServerEditorInterface;
import org.w3c.jigadmin.editors.ServerHelperFactory;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.events.ResourceActionSource;
import org.w3c.jigadmin.widgets.DnDTabbedPane;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.Utilities;

public class ServerEditor
extends JPanel
implements ServerEditorInterface {
    protected RemoteResourceWrapper server = null;
    protected String name = null;
    protected ServerHelperInterface[] shelpers = null;

    protected void build() {
        this.removeAll();
        this.invalidate();
        this.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.name);
        titledBorder.setTitleFont(Utilities.reallyBigBoldFont);
        this.setBorder(titledBorder);
        DnDTabbedPane dnDTabbedPane = new DnDTabbedPane();
        if (this.shelpers == null) {
            return;
        }
        int n = 0;
        while (n < this.shelpers.length) {
            if (this.shelpers[n] instanceof ChangeListener) {
                dnDTabbedPane.addChangeListener((ChangeListener)((Object)this.shelpers[n]));
            }
            if (this.shelpers[n] instanceof ControlServerHelper) {
                this.add(this.shelpers[n].getComponent(), "North");
            } else {
                String string = this.shelpers[n].getName().replace('_', ' ');
                char[] cArray = string.toCharArray();
                cArray[0] = Character.toUpperCase(cArray[0]);
                String string2 = new String(cArray);
                dnDTabbedPane.addTab(string2, null, this.shelpers[n].getComponent(), this.shelpers[n].getToolTip());
            }
            ++n;
        }
        dnDTabbedPane.setSelectedIndex(0);
        this.add((Component)dnDTabbedPane, "Center");
        this.validate();
    }

    public Component getComponent() {
        return this;
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.server = remoteResourceWrapper;
        this.name = string;
    }

    protected void initializeServerHelpers() throws RemoteAccessException {
        this.shelpers = null;
        RemoteResource remoteResource = this.server.getResource();
        String[] stringArray = remoteResource.enumerateResourceIdentifiers();
        Sorter.sortStringArray((String[])stringArray, (boolean)true);
        this.shelpers = new ServerHelperInterface[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            RemoteResourceWrapper remoteResourceWrapper = this.server.getChildResource(stringArray[n]);
            this.shelpers[n] = ServerHelperFactory.getServerHelper(stringArray[n], remoteResourceWrapper);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.shelpers.length) {
            if (this.shelpers[n2] instanceof ResourceActionSource) {
                ResourceActionSource resourceActionSource = (ResourceActionSource)((Object)this.shelpers[n2]);
                int n3 = 0;
                while (n3 < this.shelpers.length) {
                    if (n3 != n2 && this.shelpers[n3] instanceof ResourceActionListener) {
                        ResourceActionListener resourceActionListener = (ResourceActionListener)((Object)this.shelpers[n3]);
                        resourceActionSource.addResourceActionListener(resourceActionListener);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void setServer(RemoteResourceWrapper remoteResourceWrapper) {
        this.server = remoteResourceWrapper;
        try {
            this.initializeServerHelpers();
            this.build();
        }
        catch (RemoteAccessException remoteAccessException) {
            class Org_w3c_jigadmin_editors_ServerEditor$1 {
                /* synthetic */ Org_w3c_jigadmin_editors_ServerEditor$1() {
                }
            }
            new Retryer(null, remoteAccessException).start();
        }
    }

    private class Retryer
    extends Thread {
        RemoteAccessException ex = null;

        /* synthetic */ Retryer(1 var2_2, RemoteAccessException remoteAccessException) {
            this(remoteAccessException);
        }

        private Retryer(RemoteAccessException remoteAccessException) {
            this.ex = remoteAccessException;
        }

        public void run() {
            while (ServerEditor.this.server.getServerBrowser().shouldRetry(this.ex)) {
                try {
                    ServerEditor.this.initializeServerHelpers();
                    break;
                }
                catch (RemoteAccessException remoteAccessException) {
                    this.ex = remoteAccessException;
                }
            }
            ServerEditor.this.build();
        }
    }
}

