/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class MyHTMLEditorKit
extends HTMLEditorKit {
    public static final int JUMP = 0;
    public static final int MOVE = 1;
    LinkController myController = new LinkController();

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.myController);
        jEditorPane.addMouseMotionListener(this.myController);
    }

    public static class LinkController
    extends MouseInputAdapter
    implements Serializable {
        URL currentUrl = null;

        protected void activateLink(int n, JEditorPane jEditorPane, int n2) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                String string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                boolean bl = false;
                HyperlinkEvent hyperlinkEvent = null;
                if (string != null) {
                    URL uRL;
                    try {
                        uRL = new URL(hTMLDocument.getBase(), string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                    if (n2 == 1 && !uRL.equals(this.currentUrl)) {
                        hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ENTERED, uRL, string);
                        this.currentUrl = uRL;
                    } else if (n2 == 0) {
                        hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
                        bl = true;
                    } else {
                        return;
                    }
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                } else if (this.currentUrl != null) {
                    bl = true;
                }
                if (bl) {
                    hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.EXITED, this.currentUrl, null);
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                    this.currentUrl = null;
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            block3: {
                JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
                if (jEditorPane.isEditable()) break block3;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                try {
                    int n = jEditorPane.viewToModel(point);
                    if (n >= 0) {
                        this.activateLink(n, jEditorPane, 0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            block3: {
                JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
                if (jEditorPane.isEditable()) break block3;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                try {
                    int n = jEditorPane.viewToModel(point);
                    if (n >= 0) {
                        this.activateLink(n, jEditorPane, 1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }
}

