/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.AddFramePanel;
import org.w3c.jigadmin.editors.AddResourcePanel;
import org.w3c.jigadmin.editors.RemoteFrameWrapperNode;
import org.w3c.jigadmin.editors.RemoteResourceWrapperNode;
import org.w3c.jigadmin.editors.ResourceCell;
import org.w3c.jigadmin.editors.ResourceTreeBrowser;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;

public class FrameBrowser
extends ResourceTreeBrowser {
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("del")) {
                FrameBrowser.this.deleteSelectedResources();
            } else if (string.equals("add")) {
                FrameBrowser.this.addResourceToSelectedContainer();
            } else if (string.equals("info")) {
                FrameBrowser.this.showReferenceDocumentation();
            }
        }
    };

    protected FrameBrowser(RemoteResourceWrapperNode remoteResourceWrapperNode) {
        super(remoteResourceWrapperNode);
        this.setUI(new BasicTreeUI());
    }

    protected void addFrame(String string, RemoteResourceWrapper remoteResourceWrapper, TreePath treePath) throws RemoteAccessException {
        RemoteResource remoteResource = remoteResourceWrapper.getResource().registerFrame(null, string);
        RemoteResourceWrapper remoteResourceWrapper2 = new RemoteResourceWrapper(remoteResourceWrapper, remoteResource);
        RemoteFrameWrapperNode remoteFrameWrapperNode = (RemoteFrameWrapperNode)treePath.getLastPathComponent();
        RemoteFrameWrapperNode remoteFrameWrapperNode2 = new RemoteFrameWrapperNode(remoteFrameWrapperNode, remoteResourceWrapper2);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(remoteFrameWrapperNode2, remoteFrameWrapperNode, 0);
        this.expandPath(treePath);
    }

    protected void addResourceToSelectedContainer() {
        RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        if (remoteResourceWrapper == null) {
            JOptionPane.showMessageDialog(this, "No resource selected", "Error", 0);
            return;
        }
        if (!propertyManager.isExtensible(remoteResourceWrapper)) {
            JOptionPane.showMessageDialog(this, "The resource selected is not extensible.", "Error", 0);
        } else {
            Thread thread = new Thread(){

                public void run() {
                    FrameBrowser.this.performAddResourceToSelectedContainer();
                }
            };
            thread.start();
        }
    }

    protected void deleteResource(RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        remoteResourceWrapper.getFatherResource().unregisterFrame(remoteResourceWrapper.getResource());
    }

    protected void deleteSelectedResources() {
        int n;
        TreePath[] treePathArray = this.removeDescendants(this.getSelectionPaths());
        if (treePathArray == null) {
            return;
        }
        if (treePathArray.length > 0 && (n = JOptionPane.showConfirmDialog(this, "Delete Selected Frame(s)?", "Delete Frame(s)", 0)) == 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            int n2 = 0;
            while (n2 < treePathArray.length) {
                block8: {
                    RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper(treePathArray[n2]);
                    if (remoteResourceWrapper != null) {
                        if (remoteResourceWrapper != this.rootNode.getResourceWrapper()) {
                            try {
                                this.deleteResource(remoteResourceWrapper);
                            }
                            catch (RemoteAccessException remoteAccessException) {
                                Message.showErrorMessage((Component)this, remoteAccessException);
                                break block8;
                            }
                            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[n2].getLastPathComponent();
                            defaultTreeModel.removeNodeFromParent(mutableTreeNode);
                        } else {
                            JOptionPane.showMessageDialog(this, "You can't remove the resource here, please use the resource tree", "Information", 1);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected void doubleClick(TreePath treePath) {
    }

    protected boolean dropResource(ResourceCell resourceCell) {
        RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
        if (resourceCell.isFrame() || resourceCell.isFilter()) {
            try {
                TreePath treePath = this.getSelectionPath();
                this.addFrame(resourceCell.toString(), remoteResourceWrapper, treePath);
                return true;
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage((Component)this, remoteAccessException);
                return false;
            }
        }
        return false;
    }

    protected AddResourcePanel getAddResourcePanel(String string, RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        return new AddFramePanel(string, remoteResourceWrapper, this);
    }

    public static FrameBrowser getFrameBrowser(RemoteResourceWrapper remoteResourceWrapper, String string) {
        RemoteFrameWrapperNode remoteFrameWrapperNode = new RemoteFrameWrapperNode(remoteResourceWrapper, string);
        FrameBrowser frameBrowser = new FrameBrowser(remoteFrameWrapperNode);
        return frameBrowser;
    }

    protected JPopupMenu getPopupMenu(RemoteResourceWrapper remoteResourceWrapper) {
        boolean bl = remoteResourceWrapper.getResource().isFrame();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add frame", Icons.addIcon);
        jMenuItem.addActionListener(this.al);
        jMenuItem.setActionCommand("add");
        jPopupMenu.add(jMenuItem);
        if (bl) {
            jMenuItem = new JMenuItem("Delete frame", Icons.deleteIcon);
            jMenuItem.addActionListener(this.al);
            jMenuItem.setActionCommand("del");
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Info", Icons.infoIcon);
        jMenuItem.addActionListener(this.al);
        jMenuItem.setActionCommand("info");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void performAddResourceToSelectedContainer() {
        block2: {
            this.popupAddResourceDialog("Add Frame", this.getSelectedResourceWrapper());
            if (this.resClassname == null) break block2;
            RemoteResourceWrapper remoteResourceWrapper = this.getSelectedResourceWrapper();
            try {
                this.addFrame(this.resClassname, remoteResourceWrapper, this.getSelectionPath());
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage((Component)this, remoteAccessException);
            }
        }
    }
}

