/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.attributes;

import java.awt.Component;
import java.util.Properties;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadmin.widgets.EditableSlider;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.Attribute;

public class SlideIntegerAttributeEditor
extends AttributeEditor {
    public static final String MAX_P = "slider.max";
    public static final String MIN_P = "slider.min";
    public static final String STEP_P = "slider.step";
    public static final String BORDER_P = "slider.border";
    private int origs;
    EditableSlider widget;

    public void clearChanged() {
        this.origs = this.widget.getValue();
    }

    public Component getComponent() {
        return this.widget;
    }

    public EditableSlider getSlider(int n, int n2, int n3, int n4) {
        n = n < 0 ? 0 : n;
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        int n5 = n4 = n4 < 0 ? 0 : n4;
        if (n > n2) {
            n = n2;
        }
        if (n4 <= n) {
            n = Math.max(0, n4 - (n2 - n) / 5);
        }
        if (n4 >= n2) {
            n2 = n4 + (n2 - n) / 5;
        }
        EditableSlider editableSlider = new EditableSlider(n, n2, n3, n4);
        return editableSlider;
    }

    public Object getValue() {
        return new Integer(this.widget.getValue());
    }

    public boolean hasChanged() {
        return this.origs != this.widget.getValue();
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (properties != null) {
            try {
                n = Integer.parseInt(properties.getProperty(MIN_P, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            try {
                n2 = Integer.parseInt(properties.getProperty(MAX_P, "100"));
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 100;
            }
            try {
                n3 = Integer.parseInt(properties.getProperty(STEP_P, "5"));
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 5;
            }
        } else {
            n = 0;
            n2 = 100;
            n3 = 5;
        }
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        if (object == null) {
            Integer n4 = (Integer)remoteResource.getValue(attribute.getName());
            if (n4 == null && attribute.getDefault() != null) {
                n4 = (Integer)attribute.getDefault();
            }
            if (n4 != null) {
                this.origs = n4;
            }
        } else {
            this.origs = (Integer)object;
        }
        this.widget = this.getSlider(n, n2, n3, this.origs);
    }

    public void resetChanges() {
        this.widget.setValue(this.origs);
    }

    public void setValue(Object object) {
        this.widget.setValue((Integer)object);
    }
}

