/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.proxy.Rule;
import org.w3c.www.protocol.http.proxy.RuleParserException;

class ProxyAuthRule
extends Rule {
    URL proxy = null;
    HttpCredential credential = null;
    String user = null;
    String password = null;

    public ProxyAuthRule() {
        this.name = "proxyauth";
    }

    public Reply apply(Request request) {
        if (this.proxy != null) {
            request.setProxy(this.proxy);
        }
        if (!request.hasHeader(HttpRequestMessage.H_PROXY_AUTHORIZATION)) {
            request.setProxyAuthorization(this.credential);
        }
        return null;
    }

    public void initialize(String[] stringArray, int n, int n2) throws RuleParserException {
        if (n + 3 != n2) {
            throw new RuleParserException("Invalid proxyauth rule:  should be authorization  <user> <password> <proxy>.");
        }
        try {
            this.user = stringArray[n];
            this.password = stringArray[n + 1];
            this.credential = HttpFactory.makeCredential("Basic");
            Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(this.user) + ":" + this.password);
            this.credential.setAuthParameter("cookie", base64Encoder.processString());
            this.proxy = new URL(stringArray[n + 2]);
            this.args = String.valueOf(this.user) + " " + this.password + " " + this.proxy;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuleParserException("Invalid target proxy \"" + stringArray[n] + "\".");
        }
        this.host = stringArray[0];
    }

    public String toString() {
        return String.valueOf(this.host) + " " + this.name + " " + this.user + " " + this.password + " " + this.proxy;
    }
}

