/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.w3c.www.http.ChunkedInputStream;
import org.w3c.www.http.ContentLengthInputStream;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpStreamObserver;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.Request;

public class Reply
extends HttpReplyMessage {
    protected static HttpMimeType DEFAULT_TYPE = null;
    MimeParser parser = null;
    HttpStreamObserver observer = null;
    protected InputStream input = null;
    protected boolean definesInput = false;

    static {
        DEFAULT_TYPE = HttpFactory.makeMimeType(MimeType.TEXT_HTML);
    }

    protected Reply(MimeParser mimeParser) {
        super(mimeParser);
        this.parser = mimeParser;
    }

    protected Reply(short s, short s2, int n) {
        this.major = s;
        this.minor = s2;
        this.setStatus(n);
    }

    public InputStream getInputStream() throws IOException {
        if (this.definesInput) {
            return this.input;
        }
        switch (this.getStatus()) {
            case 204: 
            case 304: {
                return null;
            }
        }
        if (this.hasTransferEncoding("chunked")) {
            this.definesInput = true;
            this.input = new ChunkedInputStream(this.observer, this.parser.getInputStream());
            return this.input;
        }
        int n = this.getContentLength();
        if (n >= 0) {
            this.input = new ContentLengthInputStream(this.observer, this.parser.getInputStream(), n);
            this.definesInput = true;
            return this.input;
        }
        if (this.observer != null) {
            this.observer.notifyFailure(this.parser.getInputStream());
        }
        return this.parser.getInputStream();
    }

    public boolean hasInputStream() throws IOException {
        return this.getInputStream() != null;
    }

    public boolean keepsAlive() {
        if (this.major >= 1) {
            if (this.minor >= 1) {
                return this.getContentLength() >= 0 || this.hasTransferEncoding("chunked");
            }
            return this.hasConnection("keep-alive") || this.hasProxyConnection("keep-alive");
        }
        return false;
    }

    protected void matchesRequest(Request request) {
        String string = request.getMethod();
        if (string.equals("HEAD") || string.equals("OPTIONS")) {
            this.setStream(null);
        }
    }

    public void setContent(String string) {
        if (!this.hasHeader(HttpEntityMessage.H_CONTENT_TYPE)) {
            this.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)DEFAULT_TYPE);
        }
        this.setContentLength(string.length());
        this.setStream(new StringBufferInputStream(string));
    }

    public void setStream(InputStream inputStream) {
        this.input = inputStream;
        this.definesInput = true;
    }

    protected void setStreamObserver(HttpStreamObserver httpStreamObserver) {
        this.observer = httpStreamObserver;
    }
}

