/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpAcceptLanguageList;
import org.w3c.www.http.HttpAcceptList;
import org.w3c.www.http.HttpBag;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpContentRange;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpEntityTagList;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpRange;
import org.w3c.www.http.HttpRangeList;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.http.HttpSetCookieList;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.http.HttpWarning;
import org.w3c.www.http.HttpWarningList;
import org.w3c.www.mime.MimeType;

public class HttpFactory {
    public static HttpAccept makeAccept(MimeType mimeType) {
        return new HttpAccept(true, mimeType, 1.0);
    }

    public static HttpAccept makeAccept(MimeType mimeType, double d) {
        return new HttpAccept(true, mimeType, d);
    }

    public static HttpAcceptCharset makeAcceptCharset(String string) {
        return new HttpAcceptCharset(true, string, 1.0);
    }

    public static HttpAcceptCharset makeAcceptCharset(String string, double d) {
        return new HttpAcceptCharset(true, string, d);
    }

    public static HttpAcceptCharsetList makeAcceptCharsetList(HttpAcceptCharset[] httpAcceptCharsetArray) {
        return new HttpAcceptCharsetList(httpAcceptCharsetArray);
    }

    public static HttpAcceptEncoding makeAcceptEncoding(String string) {
        return new HttpAcceptEncoding(true, string, 1.0);
    }

    public static HttpAcceptEncoding makeAcceptEncoding(String string, double d) {
        return new HttpAcceptEncoding(true, string, d);
    }

    public static HttpAcceptLanguage makeAcceptLanguage(String string) {
        return new HttpAcceptLanguage(true, string, 1.0);
    }

    public static HttpAcceptLanguage makeAcceptLanguage(String string, double d) {
        return new HttpAcceptLanguage(true, string, d);
    }

    public static HttpAcceptLanguageList makeAcceptLanguageList(HttpAcceptLanguage[] httpAcceptLanguageArray) {
        return new HttpAcceptLanguageList(httpAcceptLanguageArray);
    }

    public static HttpAcceptList makeAcceptList(HttpAccept[] httpAcceptArray) {
        if (httpAcceptArray == null) {
            return new HttpAcceptList(null);
        }
        return new HttpAcceptList(httpAcceptArray);
    }

    public static HttpBag makeBag(String string) {
        return new HttpBag(true, string);
    }

    public static HttpCacheControl makeCacheControl() {
        return new HttpCacheControl(true);
    }

    public static HttpChallenge makeChallenge(String string) {
        return new HttpChallenge(true, string);
    }

    public static HttpContentRange makeContentRange(String string, int n, int n2, int n3) {
        return new HttpContentRange(true, string, n, n2, n3);
    }

    public static HttpCookie makeCookie(String string, String string2) {
        return new HttpCookie(true, string, string2);
    }

    public static HttpCookieList makeCookieList(HttpCookie[] httpCookieArray) {
        return new HttpCookieList(httpCookieArray);
    }

    public static HttpCredential makeCredential(String string) {
        return new HttpCredential(true, string);
    }

    public static HttpDate makeDate() {
        return new HttpDate(true, System.currentTimeMillis());
    }

    public static HttpDate makeDate(long l) {
        return new HttpDate(true, l);
    }

    public static HttpEntityTag makeETag(boolean bl, String string) {
        return new HttpEntityTag(true, bl, string);
    }

    public static HttpEntityTagList makeETagList(HttpEntityTag[] httpEntityTagArray) {
        return new HttpEntityTagList(httpEntityTagArray);
    }

    public static HttpInteger makeInteger(int n) {
        return new HttpInteger(true, n);
    }

    public static HttpMimeType makeMimeType(MimeType mimeType) {
        return new HttpMimeType(true, mimeType);
    }

    public static HttpRange makeRange(String string, int n, int n2) {
        return new HttpRange(true, string, n, n2);
    }

    public static HttpRangeList makeRangeList(HttpRange[] httpRangeArray) {
        return new HttpRangeList(httpRangeArray);
    }

    public static HttpSetCookie makeSetCookie(String string, String string2) {
        return new HttpSetCookie(true, string, string2);
    }

    public static HttpSetCookieList makeSetCookieList(HttpSetCookie[] httpSetCookieArray) {
        return new HttpSetCookieList(httpSetCookieArray);
    }

    public static HttpString makeString(String string) {
        return new HttpString(true, string);
    }

    public static HttpTokenList makeStringList(String string) {
        String[] stringArray = new String[]{string};
        return new HttpTokenList(stringArray);
    }

    public static HttpTokenList makeStringList(String[] stringArray) {
        return new HttpTokenList(stringArray);
    }

    public static HttpWarning makeWarning(int n) {
        return new HttpWarning(true, n, null, null);
    }

    public static HttpWarning makeWarning(int n, String string, String string2) {
        return new HttpWarning(true, n, string, string2);
    }

    public static HttpWarningList makeWarningList(HttpWarning[] httpWarningArray) {
        return new HttpWarningList(httpWarningArray);
    }

    public static HttpAccept parseAccept(String string) {
        HttpAccept httpAccept = new HttpAccept();
        httpAccept.setString(string);
        return httpAccept;
    }

    public static HttpAcceptCharset parseAcceptCharset(String string) {
        HttpAcceptCharset httpAcceptCharset = new HttpAcceptCharset();
        httpAcceptCharset.setString(string);
        return httpAcceptCharset;
    }

    public static HttpAcceptCharsetList parseAcceptCharsetList(String string) {
        HttpAcceptCharsetList httpAcceptCharsetList = new HttpAcceptCharsetList();
        httpAcceptCharsetList.setString(string);
        return httpAcceptCharsetList;
    }

    public static HttpAcceptEncoding parseAcceptEncoding(String string) {
        HttpAcceptEncoding httpAcceptEncoding = new HttpAcceptEncoding();
        httpAcceptEncoding.setString(string);
        return httpAcceptEncoding;
    }

    public static HttpAcceptLanguage parseAcceptLanguage(String string) {
        HttpAcceptLanguage httpAcceptLanguage = new HttpAcceptLanguage();
        httpAcceptLanguage.setString(string);
        return httpAcceptLanguage;
    }

    public static HttpAcceptLanguageList parseAcceptLanguageList(String string) {
        HttpAcceptLanguageList httpAcceptLanguageList = new HttpAcceptLanguageList();
        httpAcceptLanguageList.setString(string);
        return httpAcceptLanguageList;
    }

    public static HttpAcceptList parseAcceptList(String string) {
        HttpAcceptList httpAcceptList = new HttpAcceptList();
        httpAcceptList.setString(string);
        return httpAcceptList;
    }

    public static HttpBag parseBag(String string) {
        HttpBag httpBag = new HttpBag();
        httpBag.setString(string);
        return httpBag;
    }

    public static HttpCacheControl parseCacheControl(String string) {
        HttpCacheControl httpCacheControl = new HttpCacheControl();
        httpCacheControl.setString(string);
        return httpCacheControl;
    }

    public static HttpChallenge parseChallenge(String string) {
        HttpChallenge httpChallenge = new HttpChallenge();
        httpChallenge.setString(string);
        return httpChallenge;
    }

    public static HttpContentRange parseContentRange(String string) {
        HttpContentRange httpContentRange = new HttpContentRange();
        httpContentRange.setString(string);
        return httpContentRange;
    }

    public static HttpCookieList parseCookieList(String string) {
        HttpCookieList httpCookieList = new HttpCookieList();
        httpCookieList.setString(string);
        return httpCookieList;
    }

    public static HttpCredential parseCredential(String string) {
        HttpCredential httpCredential = new HttpCredential();
        httpCredential.setString(string);
        return httpCredential;
    }

    public static HttpDate parseDate(String string) {
        HttpDate httpDate = new HttpDate();
        httpDate.setString(string);
        return httpDate;
    }

    public static HttpEntityTag parseETag(String string) {
        HttpEntityTag httpEntityTag = new HttpEntityTag();
        httpEntityTag.setString(string);
        return httpEntityTag;
    }

    public static HttpEntityTagList parseEntityTagList(String string) {
        HttpEntityTagList httpEntityTagList = new HttpEntityTagList();
        httpEntityTagList.setString(string);
        return httpEntityTagList;
    }

    public static HttpInteger parseInteger(String string) {
        HttpInteger httpInteger = new HttpInteger();
        httpInteger.setString(string);
        return httpInteger;
    }

    public static HttpMimeType parseMimeType(String string) {
        HttpMimeType httpMimeType = new HttpMimeType();
        httpMimeType.setString(string);
        return httpMimeType;
    }

    public static HttpRange parseRange(String string) {
        HttpRange httpRange = new HttpRange();
        httpRange.setString(string);
        return httpRange;
    }

    public static HttpRangeList parseRangeList(String string) {
        HttpRangeList httpRangeList = new HttpRangeList();
        httpRangeList.setString(string);
        return httpRangeList;
    }

    public static HttpSetCookieList parseSetCookieList(String string) {
        HttpSetCookieList httpSetCookieList = new HttpSetCookieList();
        httpSetCookieList.setString(string);
        return httpSetCookieList;
    }

    public static HttpString parseString(String string) {
        HttpString httpString = new HttpString();
        httpString.setString(string);
        return httpString;
    }

    public static HttpTokenList parseTokenList(String string) {
        HttpTokenList httpTokenList = new HttpTokenList();
        httpTokenList.setString(string);
        return httpTokenList;
    }

    public static HttpWarning parseWarning(String string) {
        HttpWarning httpWarning = new HttpWarning();
        httpWarning.setString(string);
        return httpWarning;
    }

    public static HttpWarningList parseWarningList(String string) {
        HttpWarningList httpWarningList = new HttpWarningList();
        httpWarningList.setString(string);
        return httpWarningList;
    }
}

