/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.store;

import java.util.Hashtable;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.store.NewStoreEntry;
import org.w3c.tools.resources.store.ResourceStore;

class NewReference
implements ResourceReference {
    public static boolean debug = false;
    NewStoreEntry entry = null;
    String identifier = null;
    Hashtable defs = null;
    protected int lockCount = 0;

    NewReference(NewStoreEntry newStoreEntry, String string, Hashtable hashtable) {
        this.entry = newStoreEntry;
        this.identifier = string;
        this.defs = hashtable;
    }

    protected void invalidate() {
        this.entry = null;
    }

    public boolean isLocked() {
        return this.lockCount != 0;
    }

    protected boolean isValid() {
        return this.entry != null;
    }

    public synchronized Resource lock() throws InvalidResourceException {
        ++this.lockCount;
        if (this.entry == null) {
            throw new InvalidResourceException(this.identifier, "This reference was invalidate");
        }
        ResourceStore resourceStore = this.entry.getStore();
        Resource resource = resourceStore.lookupResource(this.identifier);
        if (debug) {
            if (this.defs.get("context") == null) {
                System.out.println("**** Context null for : " + this.identifier);
            } else if (((ResourceContext)this.defs.get("context")).getServer() == null) {
                System.out.println("**** Server null for " + this.identifier + "'s context");
            }
        }
        if (resource == null) {
            resource = resourceStore.loadResource(this.identifier, this.defs);
        }
        if (debug) {
            System.out.println("[LOCK] locking [" + this.lockCount + "]: " + this.identifier);
        }
        return resource;
    }

    public int nbLock() {
        return this.lockCount;
    }

    public void unlock() {
        --this.lockCount;
        if (debug) {
            System.out.println("[LOCK] unlocking [" + this.lockCount + "]: " + this.identifier);
        }
    }

    public void updateContext(ResourceContext resourceContext) {
        if (this.defs != null) {
            this.defs.put("context", resourceContext);
        }
    }
}

