/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.io.PrintStream;
import java.util.Hashtable;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.HolderInitException;
import org.w3c.tools.resources.IllegalAttributeAccess;

public class AttributeHolder
implements Cloneable {
    protected Attribute[] attributes = AttributeRegistry.getClassAttributes(this.getClass());
    protected Object[] values = null;

    public AttributeHolder() {
        if (this.attributes != null && this.attributes.length > 0) {
            this.values = new Object[this.attributes.length];
        }
    }

    public boolean definesAttribute(int n) throws IllegalAttributeAccess {
        return this.getValue(n, null) != null;
    }

    public boolean definesAttribute(String string) throws IllegalAttributeAccess {
        int n = this.lookupAttribute(string);
        return n >= 0 ? this.getValue(n, null) != null : false;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public boolean getBoolean(int n, boolean bl) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getBoolean");
    }

    public char getChar(int n, char c) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return c;
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getChar");
    }

    public Object getClone() {
        Object[] objectArray = new Object[this.attributes.length];
        System.arraycopy(this.values, 0, objectArray, 0, objectArray.length);
        return this.getClone(objectArray);
    }

    public Object getClone(Hashtable hashtable) {
        try {
            Object[] objectArray = new Object[this.attributes.length];
            System.arraycopy(this.values, 0, objectArray, 0, objectArray.length);
            int n = 0;
            while (n < this.attributes.length) {
                Object v = hashtable.get(this.attributes[n].getName());
                if (v != null) {
                    objectArray[n] = v;
                }
                ++n;
            }
            return this.getClone(objectArray);
        }
        catch (Exception exception) {
            String string = "Unable to create an instance of " + this.getClass();
            throw new HolderInitException(string);
        }
    }

    public Object getClone(Object[] objectArray) {
        try {
            AttributeHolder attributeHolder = (AttributeHolder)this.getClass().newInstance();
            attributeHolder.initialize(objectArray);
            return attributeHolder;
        }
        catch (Exception exception) {
            String string = "Unable to create an instance of " + this.getClass();
            throw new HolderInitException(string);
        }
    }

    public double getDouble(int n, double d) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getDouble");
    }

    public float getFloat(int n, float f) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return f;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getFloat");
    }

    public int getInt(int n, int n2) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return n2;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getInt");
    }

    public long getLong(int n, long l) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return l;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getLong");
    }

    public String getString(int n, String string) {
        Object object = this.getValue(n, null);
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalAttributeAccess(this, this.attributes[n], "getString");
    }

    public synchronized Object getValue(int n, Object object) throws IllegalAttributeAccess {
        if (n < 0 || n >= this.attributes.length) {
            throw new IllegalAttributeAccess(this, n);
        }
        Object object2 = this.values[n];
        if (object2 == null) {
            return object == null ? this.attributes[n].getDefault() : object;
        }
        return object2;
    }

    public Object getValue(String string, Object object) throws IllegalAttributeAccess {
        return this.getValue(this.lookupAttribute(string), object);
    }

    public void initialize(Hashtable hashtable) {
        Object[] objectArray = this.values == null ? new Object[this.attributes.length] : this.values;
        int n = 0;
        while (n < objectArray.length) {
            String string = this.attributes[n].getName();
            Object v = hashtable.get(string);
            if (objectArray[n] == null) {
                objectArray[n] = v;
            }
            ++n;
        }
        this.initialize(objectArray);
    }

    public void initialize(Object[] objectArray) {
        if (this.values != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (this.values[n] == null) {
                    this.values[n] = objectArray[n];
                }
                ++n;
            }
        } else {
            this.values = objectArray;
        }
    }

    public int lookupAttribute(String string) {
        int n = 0;
        while (n < this.attributes.length) {
            if (string.equals(this.attributes[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void pickleValues(Hashtable hashtable) {
        Object[] objectArray = new Object[this.attributes.length];
        int n = 0;
        while (n < objectArray.length) {
            String string = this.attributes[n].getName();
            objectArray[n] = hashtable.get(string);
            ++n;
        }
        this.values = objectArray;
    }

    public void print(PrintStream printStream) {
        int n = 0;
        while (n < this.attributes.length) {
            if (this.values[n] != null) {
                System.out.println(String.valueOf(this.attributes[n].getName()) + "=" + this.values[n]);
            }
            ++n;
        }
    }

    public void setBoolean(int n, boolean bl) {
        this.setValue(n, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setChar(int n, char c) throws IllegalAttributeAccess {
        this.setValue(n, (Object)new Character(c));
    }

    public void setDouble(int n, double d) throws IllegalAttributeAccess {
        this.setValue(n, (Object)new Double(d));
    }

    public void setFloat(int n, float f) throws IllegalAttributeAccess {
        this.setValue(n, (Object)new Float(f));
    }

    public void setInt(int n, int n2) throws IllegalAttributeAccess {
        this.setValue(n, (Object)new Integer(n2));
    }

    public void setLong(int n, long l) throws IllegalAttributeAccess {
        this.setValue(n, (Object)new Long(l));
    }

    public void setString(int n, String string) throws IllegalAttributeAccess {
        this.setValue(n, (Object)string);
    }

    public synchronized void setValue(int n, Object object) {
        if (n < 0 || n >= this.attributes.length) {
            throw new IllegalAttributeAccess(this, n);
        }
        Attribute attribute = this.attributes[n];
        if (!attribute.checkValue(object)) {
            throw new IllegalAttributeAccess(this, attribute, object);
        }
        this.values[n] = object;
    }

    public void setValue(String string, Object object) {
        this.setValue(this.lookupAttribute(string), object);
    }

    public Object unsafeGetValue(int n, Object object) throws IllegalAttributeAccess {
        if (n < 0 || n >= this.attributes.length) {
            throw new IllegalAttributeAccess(this, n);
        }
        Object object2 = this.values[n];
        if (object2 == null) {
            return object == null ? this.attributes[n].getDefault() : object;
        }
        return object2;
    }
}

