/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.w3c.tools.jdbc.ConnectionManager;
import org.w3c.tools.jdbc.Jdbc;
import org.w3c.tools.jdbc.JdbcConnection;
import org.w3c.tools.jdbc.JdbcServerState;

public class JdbcServer {
    public static final boolean debug = false;
    String uri = null;
    String user = null;
    String password = null;
    ConnectionManager manager = null;
    JdbcServerState state = null;
    protected static HashMap servers = new HashMap();
    protected static Vector drivers = new Vector();
    protected static Properties defaultProps = new Properties();

    protected JdbcServer(String string, String string2, String string3, ConnectionManager connectionManager) {
        this.uri = string;
        this.user = string2;
        this.password = string3;
        this.state = new JdbcServerState(this);
        this.manager = connectionManager;
    }

    public void deleteConnection(JdbcConnection jdbcConnection) {
        this.manager.deleteConnection(jdbcConnection);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        JdbcConnection jdbcConnection = null;
        int n = 3;
        int n2 = 0;
        while (databaseMetaData == null && n2 < n) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection != null) {
                try {
                    databaseMetaData = jdbcConnection.getMetaData();
                }
                finally {
                    Object var6_5 = null;
                    this.manager.notifyIdle(jdbcConnection);
                }
            }
            ++n2;
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return databaseMetaData;
    }

    public static JdbcServer getServer(String string, String string2, String string3) {
        return JdbcServer.getServer(string, string2, string3, null, System.getProperties());
    }

    public static JdbcServer getServer(String string, String string2, String string3, String string4) {
        return JdbcServer.getServer(string, string2, string3, string4, defaultProps);
    }

    public static JdbcServer getServer(String string, String string2, String string3, String string4, Properties properties) {
        if (drivers == null) {
            drivers = new Vector(4);
        }
        if (string4 != null && !drivers.contains(string4)) {
            try {
                Class.forName(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            drivers.addElement(string4);
        }
        String string5 = null;
        string5 = string2 != null ? String.valueOf(string) + "?" + string2 : string;
        JdbcServer jdbcServer = null;
        jdbcServer = (JdbcServer)servers.get(string5);
        if (jdbcServer != null) {
            jdbcServer.updateProperties(properties);
            return jdbcServer;
        }
        ConnectionManager connectionManager = ConnectionManager.getManager(properties);
        jdbcServer = new JdbcServer(string, string2, string3, connectionManager);
        servers.put(string5, jdbcServer);
        return jdbcServer;
    }

    public static JdbcServer getServer(String string, Properties properties) {
        return JdbcServer.getServer(string, Jdbc.getUser(properties), Jdbc.getPassword(properties), Jdbc.getDriver(properties), properties);
    }

    protected final JdbcServerState getState() {
        return this.state;
    }

    public ResultSet runQuery(String string, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        JdbcConnection jdbcConnection = null;
        int n = 3;
        boolean bl2 = bl;
        int n2 = 0;
        while (resultSet == null && n2 < n) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection != null) {
                Object var9_8;
                try {
                    try {
                        resultSet = jdbcConnection.performQuery(string);
                    }
                    catch (SQLException sQLException) {
                        bl2 = true;
                        throw sQLException;
                    }
                    var9_8 = null;
                    if (bl2) {
                        jdbcConnection.delete();
                    } else {
                        this.manager.notifyIdle(jdbcConnection);
                    }
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    if (bl2) {
                        jdbcConnection.delete();
                    } else {
                        this.manager.notifyIdle(jdbcConnection);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return resultSet;
    }

    public ResultSet runRequest(String string, boolean bl) throws SQLException {
        return this.runQuery(string, bl);
    }

    public int runUpdate(String string, boolean bl) throws SQLException {
        int n = -1;
        JdbcConnection jdbcConnection = null;
        int n2 = 3;
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            jdbcConnection = this.manager.getConnection(this);
            if (jdbcConnection != null) {
                Object var8_7;
                try {
                    try {
                        n = jdbcConnection.performUpdate(string);
                    }
                    catch (SQLException sQLException) {
                        bl = true;
                        throw sQLException;
                    }
                    var8_7 = null;
                    if (bl) {
                        jdbcConnection.delete();
                    } else {
                        this.manager.notifyIdle(jdbcConnection);
                    }
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (bl) {
                        jdbcConnection.delete();
                    } else {
                        this.manager.notifyIdle(jdbcConnection);
                    }
                    throw throwable;
                }
            }
            ++n3;
        }
        if (jdbcConnection == null) {
            throw new SQLException("Can't connect to database");
        }
        return n;
    }

    public String toString() {
        return this.uri;
    }

    public synchronized void unregisterConnection(JdbcConnection jdbcConnection) {
        this.manager.notifyUse(jdbcConnection);
    }

    protected void updateProperties(Properties properties) {
        this.manager = ConnectionManager.getManager(properties);
    }
}

