/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.webdav;

import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.webdav.DAVReply;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.webdav.DAVIf;
import org.w3c.www.webdav.DAVIfList;
import org.w3c.www.webdav.WEBDAV;

public class DAVRequest
extends Request
implements WEBDAV {
    static {
        HttpMessage.registerHeader("Depth", "org.w3c.www.http.HttpString");
        HttpMessage.registerHeader("Destination", "org.w3c.www.http.HttpString");
        HttpMessage.registerHeader("If", "org.w3c.www.webdav.DAVIfList");
        HttpMessage.registerHeader("Lock-Token", "org.w3c.www.http.HttpString");
        HttpMessage.registerHeader("Overwrite", "org.w3c.www.http.HttpString");
        HttpMessage.registerHeader("Timeout", "org.w3c.www.http.HttpTokenList");
    }

    public DAVRequest(Client client, MimeParser mimeParser) {
        super(client, mimeParser);
        this.parser = mimeParser;
        this.client = client;
    }

    public static final String depthToString(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
        }
        return "Infinity";
    }

    public int getDepth() {
        HeaderValue headerValue = this.getHeaderValue("Depth");
        if (headerValue == null) {
            return -1;
        }
        String string = (String)headerValue.getValue();
        if (string.equals("0")) {
            return 0;
        }
        if (string.equals("1")) {
            return 1;
        }
        return -1;
    }

    public String getDestination() {
        HeaderValue headerValue = this.getHeaderValue("Destination");
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public DAVIf[] getIf() {
        HeaderValue headerValue = this.getHeaderValue("If");
        return headerValue != null ? (DAVIf[])headerValue.getValue() : null;
    }

    public String getLockToken() {
        HeaderValue headerValue = this.getHeaderValue("Lock-Token");
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public boolean getOverwrite() {
        HeaderValue headerValue = this.getHeaderValue("Overwrite");
        String string = headerValue != null ? (String)headerValue.getValue() : null;
        return "F".equals(string) ^ true;
    }

    public String[] getTimeout() {
        HeaderValue headerValue = this.getHeaderValue("Timeout");
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public boolean isTaggedListIfHeader() {
        DAVIfList dAVIfList = (DAVIfList)this.getHeaderValue("If");
        return dAVIfList.isTaggedList();
    }

    public ReplyInterface makeBadRequestReply() {
        return this.makeReply(400);
    }

    public DAVReply makeDAVReply(int n) {
        DAVReply dAVReply = new DAVReply(this.client, this, this.getMajorVersion(), this.getMinorVersion(), n);
        if (this.filters != null && this.infilters > 0) {
            dAVReply.setFilters(this.filters, this.infilters);
        }
        return dAVReply;
    }

    public Reply makeReply(int n) {
        return this.makeDAVReply(n);
    }
}

