/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.status;

import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.status.GcCounter;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;

public class GcStatFrame
extends HTTPFrame {
    private static int REFRESH_DEFAULT = 30;
    protected static int ATTR_REFRESH = -1;
    protected Runtime runtime = null;

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.status.GcStatFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("refresh", new Integer(5), 2);
        ATTR_REFRESH = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }

    protected Reply dumpMemoryStatus(Request request) {
        HtmlGenerator htmlGenerator = new HtmlGenerator("Memory Status");
        int n = this.getInt(ATTR_REFRESH, REFRESH_DEFAULT);
        if (n > 0) {
            htmlGenerator.addMeta("Refresh", Integer.toString(n));
        }
        this.addStyleSheet(htmlGenerator);
        htmlGenerator.append("<h1>Memory status</h1>");
        long l = this.runtime.freeMemory();
        long l2 = l / 1024L;
        long l3 = l2 / 1024L;
        if (l3 != 0L) {
            htmlGenerator.append("<p>Free Memory: " + l3 + "Mb, " + l2 % 1024L + "Kb, " + l % 1024L + " (" + Long.toString(l) + ")");
        } else if (l2 != 0L) {
            htmlGenerator.append("<p>Free Memory: " + l2 + "Kb, " + l % 1024L + " (" + Long.toString(l) + ")");
        } else {
            htmlGenerator.append("<p>Free Memory:" + Long.toString(l));
        }
        l = this.runtime.totalMemory();
        l2 = l / 1024L;
        l3 = l2 / 1024L;
        if (l3 != 0L) {
            htmlGenerator.append("<p>Total Memory: " + l3 + "Mb, " + l2 % 1024L + "Kb, " + l % 1024L + " (" + Long.toString(l) + ")");
        } else if (l2 != 0L) {
            htmlGenerator.append("<p>Total Memory: " + l2 + "Kb, " + l % 1024L + " (" + Long.toString(l) + ")");
        } else {
            htmlGenerator.append("<p>Total Memory:", Long.toString(l));
        }
        htmlGenerator.append("<p>GC count: " + GcCounter.getGcCount());
        htmlGenerator.append("<hr>");
        Reply reply = request.makeReply(200);
        reply.setNoCache();
        reply.setStream(htmlGenerator);
        return reply;
    }

    public Reply get(Request request) {
        return this.dumpMemoryStatus(request);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.runtime = Runtime.getRuntime();
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }
}

