/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.pics.LabelBureauFactory;
import org.w3c.jigsaw.pics.LabelBureauInterface;
import org.w3c.jigsaw.pics.LabelInterface;
import org.w3c.jigsaw.pics.LabelServiceInterface;
import org.w3c.jigsaw.pics.PICS;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;

public class LabelBureauResource
extends FramedResource {
    protected static int ATTR_BUREAU_IDENTIFIER = -1;
    protected static int ATTR_BUREAU_SERVICES = -1;
    protected static int ATTR_BUREAU_DEBUG = -1;
    protected LabelBureauInterface bureau = null;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.pics.LabelBureauResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new FileAttribute("bureau", null, 6);
        ATTR_BUREAU_IDENTIFIER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("services", null, 2);
        ATTR_BUREAU_SERVICES = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("debug", Boolean.FALSE, 2);
        ATTR_BUREAU_DEBUG = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    protected final void acquireBureau() {
        if (this.bureau != null) {
            return;
        }
        File file = this.getBureauIdentifier();
        if (file != null) {
            this.bureau = LabelBureauFactory.getLabelBureau(this.getBureauIdentifier());
        }
    }

    public File getBureauIdentifier() {
        return (File)this.getValue(ATTR_BUREAU_IDENTIFIER, null);
    }

    public boolean getDebugFlag() {
        return this.getBoolean(ATTR_BUREAU_DEBUG, false);
    }

    protected Reply getGenericLabels(Request request, int n, String[] stringArray, String[] stringArray2, URLDecoder uRLDecoder) throws HTTPException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(PICS-1.1");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            LabelServiceInterface labelServiceInterface = this.bureau.getLabelService(stringArray2[n2]);
            if (labelServiceInterface == null) {
                stringBuffer.append(" error (no-ratings \"unknown service\")");
            } else {
                labelServiceInterface.dump(stringBuffer, n);
                stringBuffer.append(" labels ");
                try {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        LabelInterface labelInterface = labelServiceInterface.getGenericLabel(new URL(stringArray[n3]));
                        if (labelInterface == null) {
                            stringBuffer.append(" error (not-labeled \"" + stringArray[n3] + "\")");
                        } else {
                            if (n3 != 0) {
                                stringBuffer.append(" ");
                            }
                            labelInterface.dump(stringBuffer, n);
                        }
                        ++n3;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Reply reply = request.makeReply(400);
                    reply.setContent("You are requesting an invalid URL,");
                    throw new HTTPException(reply);
                }
            }
            ++n2;
        }
        stringBuffer.append(")");
        return this.makePICSReply(request, stringBuffer);
    }

    protected Reply getGenericTreeLabels(Request request, int n, String[] stringArray, String[] stringArray2, URLDecoder uRLDecoder) throws HTTPException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(PICS-1.1");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            LabelServiceInterface labelServiceInterface = this.bureau.getLabelService(stringArray2[n2]);
            if (labelServiceInterface == null) {
                stringBuffer.append(" error (no-ratings \"unknown service\")");
            } else {
                labelServiceInterface.dump(stringBuffer, n);
                stringBuffer.append(" labels ");
                try {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        URL uRL = new URL(stringArray[n3]);
                        LabelInterface[] labelInterfaceArray = labelServiceInterface.getGenericTreeLabels(uRL);
                        if (labelInterfaceArray == null) {
                            stringBuffer.append(" error (not-labeled \"" + stringArray[n3] + "\")");
                        } else {
                            stringBuffer.append(n3 == 0 ? "(" : " (");
                            int n4 = 0;
                            while (n4 < labelInterfaceArray.length) {
                                if (n4 != 0) {
                                    stringBuffer.append(" ");
                                }
                                labelInterfaceArray[n4].dump(stringBuffer, n);
                                ++n4;
                            }
                            stringBuffer.append(")");
                        }
                        ++n3;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Reply reply = request.makeReply(400);
                    reply.setContent("You are requesting an invalid URL.");
                    throw new HTTPException(reply);
                }
            }
            ++n2;
        }
        stringBuffer.append(")");
        return this.makePICSReply(request, stringBuffer);
    }

    protected Reply getNormalLabels(Request request, int n, String[] stringArray, String[] stringArray2, URLDecoder uRLDecoder) throws HTTPException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(PICS-1.1");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            LabelServiceInterface labelServiceInterface = this.bureau.getLabelService(stringArray2[n2]);
            if (labelServiceInterface == null) {
                stringBuffer.append(" error (no-ratings \"unknown service\")");
            } else {
                labelServiceInterface.dump(stringBuffer, n);
                stringBuffer.append(" labels ");
                try {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        URL uRL = new URL(stringArray[n3]);
                        LabelInterface labelInterface = labelServiceInterface.getSpecificLabel(uRL);
                        if (labelInterface == null && (labelInterface = labelServiceInterface.getGenericLabel(uRL)) == null) {
                            stringBuffer.append(" error (not-labeled \"" + stringArray[n3] + "\")");
                        } else {
                            if (n3 != 0) {
                                stringBuffer.append(" ");
                            }
                            labelInterface.dump(stringBuffer, n);
                        }
                        ++n3;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Reply reply = request.makeReply(400);
                    reply.setContent("You are requesting an invalid URL.");
                    throw new HTTPException(reply);
                }
            }
            ++n2;
        }
        stringBuffer.append(")");
        return this.makePICSReply(request, stringBuffer);
    }

    public String[] getServices() {
        return (String[])this.getValue(ATTR_BUREAU_SERVICES, null);
    }

    protected Reply getTreeLabels(Request request, int n, String[] stringArray, String[] stringArray2, URLDecoder uRLDecoder) throws HTTPException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("(PICS-1.1");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            LabelServiceInterface labelServiceInterface = this.bureau.getLabelService(stringArray2[n2]);
            if (labelServiceInterface == null) {
                stringBuffer.append(" error (no-ratings \"unknown service\")");
            } else {
                labelServiceInterface.dump(stringBuffer, n);
                stringBuffer.append(" labels ");
                try {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        boolean bl = false;
                        LabelInterface[] labelInterfaceArray = labelServiceInterface.getTreeLabels(new URL(stringArray[n3]));
                        if (labelInterfaceArray == null) {
                            stringBuffer.append(" error (not-labeled \"" + stringArray[n3] + "\")");
                        } else {
                            stringBuffer.append(n3 == 0 ? "(" : " (");
                            int n4 = 0;
                            while (n4 < labelInterfaceArray.length) {
                                if (n4 != 0) {
                                    stringBuffer.append(" ");
                                }
                                labelInterfaceArray[n4].dump(stringBuffer, n);
                                ++n4;
                            }
                            stringBuffer.append(")");
                        }
                        ++n3;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Reply reply = request.makeReply(400);
                    reply.setContent("You are requesting an invalid URL.");
                    throw new HTTPException(reply);
                }
            }
            ++n2;
        }
        stringBuffer.append(")");
        return this.makePICSReply(request, stringBuffer);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.acquireBureau();
        try {
            this.registerFrameIfNone("org.w3c.jigsaw.pics.LabelBureauFrame", "label-bureau-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PICS.setDebug(this.getDebugFlag());
    }

    protected Reply makePICSErrorReply(Request request, String string) {
        Reply reply = request.makeReply(200);
        reply.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)PICS.APPLICATION_PICSLABEL);
        String string2 = "(PICS-1.1 error (" + string + "))";
        reply.setContent(string2);
        if (this.getDebugFlag()) {
            System.out.println("********* PICS REPLY *********");
            System.out.println(string2);
            System.out.println("******************************");
        }
        return reply;
    }

    protected Reply makePICSReply(Request request, StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        Reply reply = request.makeReply(200);
        reply.setHeaderValue(HttpEntityMessage.H_CONTENT_TYPE, (HeaderValue)PICS.APPLICATION_PICSLABEL);
        reply.setContent(string);
        if (this.getDebugFlag()) {
            System.out.println("********* PICS REPLY *********");
            System.out.println(string);
            System.out.println("******************************");
        }
        return reply;
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_BUREAU_DEBUG) {
            PICS.setDebug(this.getDebugFlag());
        }
    }
}

