// ProxyRequestObserver.java
// $Id: ProxyRequestObserver.java,v 1.7 2000/08/17 13:03:57 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.proxy ;

import java.io.IOException;

import org.w3c.www.protocol.http.ContinueEvent;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestEvent;
import org.w3c.www.protocol.http.RequestObserver;

public class ProxyRequestObserver implements RequestObserver {
    /**
     * Our client, ie the one that sends us a request to fulfill.
     */
    org.w3c.jigsaw.http.Request request = null;
    /**
     * Call back, invoked by the HttpManager callback thread.
     * Each time a request status changes (due to progress in its processing)
     * this callback gets called, with the new status as an argument.
     * @param preq The pending request that has made some progress.
     * @param event The event to broadcast.
     */

    public void notifyProgress(RequestEvent event) {
	Request req = event.request;

	if ( event instanceof ContinueEvent ) {
	    // We need to forward this straight to the client:
	    try {
		request.getClient().sendContinue();
	    } catch (IOException ex) {
		// This will fail latter on too, forget about it (!)
	    }
	}
    }

    public ProxyRequestObserver(org.w3c.jigsaw.http.Request request) {
	this.request = request;
    }

}
