/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ResourceCell;
import org.w3c.jigadmin.editors.ResourceCellRenderer;
import org.w3c.jigadmin.editors.ResourceTreeBrowser;
import org.w3c.jigadmin.widgets.EditableStringChoice;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.sorter.Sorter;

public class AddResourcePanel
extends JPanel {
    protected boolean ok = false;
    protected EditableStringChoice classSC;
    protected JTextField identifierTF;
    protected ResourceTreeBrowser browser = null;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Ok") || actionEvent.getSource().equals(AddResourcePanel.this.identifierTF)) {
                if (!AddResourcePanel.this.classSC.getText().equals("")) {
                    if (!AddResourcePanel.this.identifierTF.getText().equals("")) {
                        AddResourcePanel.this.browser.setResourceToAdd(AddResourcePanel.this.classSC.getText(), AddResourcePanel.this.identifierTF.getText());
                        AddResourcePanel.this.browser.disposeAddResourcePopup();
                        AddResourcePanel.this.done();
                    } else {
                        AddResourcePanel.this.identifierTF.requestFocus();
                    }
                } else {
                    AddResourcePanel.this.classSC.requestFocus();
                }
            } else if (actionEvent.getActionCommand().equals("Cancel")) {
                AddResourcePanel.this.browser.setResourceToAdd(null, null);
                AddResourcePanel.this.browser.disposeAddResourcePopup();
                AddResourcePanel.this.done();
            } else if (actionEvent.getSource().equals(AddResourcePanel.this.classSC)) {
                AddResourcePanel.this.identifierTF.requestFocus();
            }
        }
    };

    protected AddResourcePanel(String string, RemoteResourceWrapper remoteResourceWrapper, ResourceTreeBrowser resourceTreeBrowser) throws RemoteAccessException {
        this.browser = resourceTreeBrowser;
        this.build(remoteResourceWrapper, string);
    }

    protected void build(RemoteResourceWrapper remoteResourceWrapper, String string) throws RemoteAccessException {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.initializeStringChoice(remoteResourceWrapper);
        this.identifierTF = new JTextField(25);
        this.identifierTF.addActionListener(this.al);
        this.identifierTF.setBorder(BorderFactory.createLoweredBevelBorder());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 10, 16, 5);
        this.setLayout(gridBagLayout2);
        JLabel jLabel = new JLabel("Class name: ", 4);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.classSC, gridBagConstraints);
        jPanel.add(this.classSC);
        jLabel = new JLabel("Identifier: ", 4);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.identifierTF, gridBagConstraints);
        jPanel.add(this.identifierTF);
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints2);
        this.add(jPanel);
        jPanel = new JPanel(new GridLayout(1, 2, 20, 20));
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(this.al);
        jPanel.add(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this.al);
        jPanel.add(jButton);
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints2);
        this.add(jPanel);
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    protected synchronized void done() {
        this.ok = true;
        this.notifyAll();
    }

    protected void getFocus() {
        this.classSC.requestFocus();
    }

    protected Hashtable getResources(RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        if (remoteResource.isIndexersCatalog()) {
            return propertyManager.getIndexers();
        }
        return propertyManager.getResources();
    }

    protected void initializeStringChoice(RemoteResourceWrapper remoteResourceWrapper) throws RemoteAccessException {
        Object[] objectArray;
        this.classSC = new EditableStringChoice();
        Hashtable hashtable = this.getResources(remoteResourceWrapper);
        Enumeration enumeration = Sorter.sortStringEnumeration(hashtable.keys()).elements();
        Vector<ResourceCell> vector = new Vector<ResourceCell>(10);
        while (enumeration.hasMoreElements()) {
            objectArray = (String)enumeration.nextElement();
            ResourceCell resourceCell = new ResourceCell((String)objectArray, (String)hashtable.get(objectArray));
            vector.addElement(resourceCell);
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.classSC.initialize(objectArray);
        this.classSC.setRenderer(new ResourceCellRenderer());
        this.classSC.setMaximumRowCount(5);
    }

    public synchronized boolean waitForCompletion() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        return this.ok;
    }
}

