/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.attributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadm.editors.EditorFeeder;
import org.w3c.jigadmin.widgets.ClosableDialog;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigadmin.widgets.ListEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.TextEditable;

public class StringArrayEditor
extends AttributeEditor {
    protected JFrame frame = null;
    public static final String FEEDER_CLASS_P = "feeder.class";
    protected boolean hasChanged = false;
    protected String[] oldvalue = null;
    protected StringArrayComponent comp = null;

    public void clearChanged() {
        this.hasChanged = false;
    }

    protected void createComponent(EditorFeeder editorFeeder, String[] stringArray) {
        if (this.comp == null) {
            this.comp = new StringArrayComponent(this, stringArray, editorFeeder);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    protected Dimension getPopupSize() {
        return new Dimension(350, 250);
    }

    protected TextEditable getTextEditor() {
        return new TextEditor(15);
    }

    public Object getValue() {
        String[] stringArray = this.comp.getSelectedItems();
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        String[] stringArray;
        EditorFeeder editorFeeder = null;
        String string = null;
        string = (String)((Hashtable)properties).get(FEEDER_CLASS_P);
        if (string == null) {
            throw new RuntimeException("StringArrayEditor mis-configuration: feeder.class property undefined.");
        }
        try {
            stringArray = Class.forName(string);
            editorFeeder = (EditorFeeder)stringArray.newInstance();
            editorFeeder.initialize(remoteResourceWrapper, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("StringArrayEditor mis-configured:  unable to instantiate " + string + ".");
        }
        this.frame = ((org.w3c.jigadmin.RemoteResourceWrapper)remoteResourceWrapper).getServerBrowser().getFrame();
        stringArray = StringArrayEditor.toStringArray(object);
        this.createComponent(editorFeeder, stringArray);
        this.oldvalue = stringArray;
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setSelectedItems(this.oldvalue);
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public void setValue(Object object) {
        this.oldvalue = (String[])object;
        this.comp.setSelectedItems(this.oldvalue);
    }

    public static String[] toStringArray(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                stringArray[n] = objectArray[n].toString();
                ++n;
            }
            return stringArray;
        }
        throw new ClassCastException("Object array required");
    }

    class EditStringArrayPopup
    extends ClosableDialog
    implements ActionListener {
        protected StringArrayComponent parent = null;
        protected EditorFeeder feeder = null;
        protected Vector selected = null;
        protected Vector vitems = null;
        protected JList witems = null;
        protected JPanel items = null;
        protected JPanel pitems = null;
        protected JButton waddItem = null;
        protected JButton wdelItem = null;
        protected JList wselected = null;
        protected JPanel pselected = null;
        protected TextEditable newItem = null;
        protected boolean modified = false;

        public EditStringArrayPopup(StringArrayComponent stringArrayComponent, EditorFeeder editorFeeder, String[] stringArray, String string) {
            super(StringArrayEditor.this.frame, string, false);
            this.parent = stringArrayComponent;
            this.feeder = editorFeeder;
            this.newItem = stringArrayComponent.editor.getTextEditor();
            this.createDefaultItems(editorFeeder);
            this.createSelectedItems(stringArray);
            this.waddItem = new JButton(Icons.copyLIcon);
            this.waddItem.setActionCommand("add");
            this.waddItem.addActionListener(this);
            this.wdelItem = new JButton(Icons.copyRIcon);
            this.wdelItem.setActionCommand("del");
            this.wdelItem.addActionListener(this);
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
            jPanel.add(this.wdelItem);
            jPanel.add(this.waddItem);
            JButton jButton = new JButton("Ok");
            jButton.setActionCommand("update");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setActionCommand("cancel");
            jButton2.addActionListener(this);
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Selection"));
            jPanel3.add((Component)new JScrollPane(this.wselected), "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout(3, 3));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Choice"));
            this.newItem.addActionListener((ActionListener)this);
            jPanel4.add((Component)this.newItem, "North");
            jPanel4.add((Component)new JScrollPane(this.witems), "Center");
            JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 5, 5));
            jPanel5.add(jPanel3);
            jPanel5.add(jPanel4);
            JPanel jPanel6 = new JPanel(new BorderLayout(0, 5));
            jPanel6.add((Component)jPanel, "North");
            jPanel6.add((Component)jPanel5, "Center");
            jPanel6.add((Component)jPanel2, "South");
            jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(jPanel6);
            this.updateSize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("add")) {
                if (this.newItem.updated()) {
                    this.modified = true;
                    this.selected.addElement(this.newItem.getText());
                }
                this.newItem.setDefault();
                Object[] objectArray = this.witems.getSelectedValues();
                if (objectArray != null && objectArray.length > 0) {
                    this.modified = true;
                    int n = 0;
                    while (n < objectArray.length) {
                        this.selected.addElement(objectArray[n]);
                        this.vitems.removeElement(objectArray[n]);
                        ++n;
                    }
                }
                this.wselected.setListData(this.selected);
                this.witems.setListData(this.vitems);
            } else if (string.equals("del")) {
                Object[] objectArray = this.wselected.getSelectedValues();
                if (objectArray != null && objectArray.length > 0) {
                    this.modified = true;
                    int n = 0;
                    while (n < objectArray.length) {
                        this.vitems.addElement(objectArray[n]);
                        this.selected.removeElement(objectArray[n]);
                        ++n;
                    }
                    this.wselected.setListData(this.selected);
                    this.witems.setListData(this.vitems);
                }
            } else if (string.equals("update")) {
                if (this.modified) {
                    Object[] objectArray = new String[this.selected.size()];
                    this.selected.copyInto(objectArray);
                    this.parent.setSelectedItems((String[])objectArray);
                    this.parent.setModified();
                }
                this.close();
            } else if (string.equals("cancel")) {
                this.close();
            } else if (actionEvent.getSource().equals(this.newItem)) {
                if (this.newItem.updated()) {
                    this.modified = true;
                    this.selected.addElement(this.newItem.getText());
                }
                this.newItem.setDefault();
                this.wselected.setListData(this.selected);
                ((Component)this.newItem).requestFocus();
            }
        }

        protected void close() {
            this.modified = false;
            ((Component)this).setVisible(false);
            this.dispose();
        }

        protected void createDefaultItems(EditorFeeder editorFeeder) {
            this.witems = new JList();
            this.witems.setSelectionMode(2);
            String[] stringArray = editorFeeder.getDefaultItems();
            if (stringArray != null) {
                this.vitems = new Vector(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.vitems.addElement(stringArray[n]);
                    ++n;
                }
                this.witems.setListData(this.vitems);
            } else {
                this.vitems = new Vector();
            }
        }

        protected void createSelectedItems(String[] stringArray) {
            this.wselected = new JList();
            this.wselected.setSelectionMode(2);
            if (stringArray != null) {
                this.selected = new Vector(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.selected.addElement(stringArray[n]);
                    ++n;
                }
                this.wselected.setListData(this.selected);
            } else {
                this.selected = new Vector();
            }
        }

        protected void updateSize() {
            ((Component)this).setSize(this.parent.editor.getPopupSize());
        }
    }

    class StringArrayComponent
    extends ListEditor {
        protected StringArrayEditor editor = null;
        protected String[] selected = null;
        protected EditorFeeder feeder = null;

        StringArrayComponent(StringArrayEditor stringArrayEditor2, String[] stringArray, EditorFeeder editorFeeder) {
            super(5, true);
            this.editor = stringArrayEditor2;
            this.feeder = editorFeeder;
            this.setSelectedItems(stringArray);
        }

        protected void edit() {
            EditStringArrayPopup editStringArrayPopup = new EditStringArrayPopup(this, this.feeder, this.getSelectedItems(), "Edit");
            editStringArrayPopup.setLocationRelativeTo(this);
            editStringArrayPopup.show();
            editStringArrayPopup.toFront();
        }

        protected String[] getSelectedItems() {
            return this.selected;
        }

        public void setModified() {
            this.editor.setModified();
        }

        protected void setSelectedItems(String[] stringArray) {
            this.selected = stringArray;
            this.list.removeAll();
            if (stringArray != null) {
                this.list.setListData(stringArray);
            }
        }
    }

    class TextEditor
    extends JTextField
    implements TextEditable {
        TextEditor(int n) {
            super(n);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void setDefault() {
            this.setText("");
        }

        public boolean updated() {
            return this.getText().length() > 0 && !this.getText().equals("");
        }
    }
}

