/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.attributes;

import java.awt.Component;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.Attribute;

public class ClassAttributeEditor
extends AttributeEditor {
    private Class origs;
    JTextField widget = new JTextField();

    public ClassAttributeEditor() {
        this.widget.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void clearChanged() {
        this.origs = this.getClassAttribute();
    }

    protected Class getClassAttribute() {
        String string = this.widget.getText();
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Message.showErrorMessage((Component)this.widget, (Exception)classNotFoundException);
                return null;
            }
        }
        return null;
    }

    public Component getComponent() {
        return this.widget;
    }

    public Object getValue() {
        return this.getClassAttribute();
    }

    public boolean hasChanged() {
        if (this.origs == null) {
            return this.widget.getText().equals("") ^ true;
        }
        return this.origs.getName().equals(this.widget.getText()) ^ true;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        if (object == null) {
            Class clazz = (Class)remoteResource.getValue(attribute.getName());
            if (clazz == null && attribute.getDefault() != null) {
                clazz = (Class)attribute.getDefault();
            }
            if (clazz != null) {
                this.origs = clazz;
                this.setClassAttribute(this.origs);
            }
        } else {
            this.origs = (Class)object;
        }
        this.setClassAttribute(this.origs);
    }

    public void resetChanges() {
        this.setClassAttribute(this.origs);
    }

    protected void setClassAttribute(Class clazz) {
        if (clazz != null) {
            this.widget.setText(clazz.getName());
        } else {
            this.widget.setText("");
        }
    }

    public void setValue(Object object) {
        this.setClassAttribute((Class)object);
    }
}

