/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.filters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.cvs.UncheckedOutException;
import org.w3c.jigedit.filters.DeletedEntry;
import org.w3c.jigedit.filters.PutedEntry;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;
import org.w3c.util.IO;
import org.w3c.util.ObservableProperties;

public class PutListResource
extends FramedResource {
    protected static final boolean debug = true;
    public static final int FILE_PB = 1;
    public static final int FILE_UC = 2;
    public static final int FILE_MG = 3;
    public static final int FILE_CF = 4;
    public static final int FILE_DEL = 5;
    protected static int ATTR_FILE = -1;
    protected static int ATTR_SPACE = -1;
    protected static int ATTR_ROOT = -1;
    protected static int ATTR_AUTO_PUBLISH = -1;
    protected static int ATTR_AUTO_DELETE = -1;
    protected static int ATTR_MAX_PUBLISHED = -1;
    protected static Serializer serializer;
    private Hashtable entries = new Hashtable(11);
    private Hashtable dentries = new Hashtable(11);
    private Hashtable published = new Hashtable(11);
    ObservableProperties props = null;

    static {
        Class<?> clazz = null;
        FileAttribute fileAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.filters.PutListResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        fileAttribute = new FileAttribute("file", null, 6);
        ATTR_FILE = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        fileAttribute = new FileAttribute("space", null, 6);
        ATTR_SPACE = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        fileAttribute = new FileAttribute("root", null, 6);
        ATTR_ROOT = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        fileAttribute = new BooleanAttribute("auto-publish", Boolean.FALSE, 2);
        ATTR_AUTO_PUBLISH = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        fileAttribute = new BooleanAttribute("auto-delete", Boolean.FALSE, 2);
        ATTR_AUTO_DELETE = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        fileAttribute = new IntegerAttribute("max-published", new Integer(10), 2);
        ATTR_MAX_PUBLISHED = AttributeRegistry.registerAttribute(clazz, (Attribute)fileAttribute);
        serializer = null;
        serializer = new XMLSerializer();
    }

    protected void addDelEntry(DeletedEntry deletedEntry) {
        this.dentries.put(deletedEntry.getKey(), deletedEntry);
    }

    protected void addEntry(PutedEntry putedEntry) {
        this.entries.put(putedEntry.getKey(), putedEntry);
    }

    protected synchronized void addPubEntry(PutedEntry putedEntry) {
        while (this.published.size() >= this.getMaxPublishedEntryStored()) {
            this.removeOldestPublishedEntry();
        }
        this.published.put(putedEntry.getKey(), putedEntry);
    }

    public synchronized int confirmDelete(Request request) {
        DeletedEntry deletedEntry = this.lookupDelEntry(request);
        if (deletedEntry != null) {
            deletedEntry.confirm();
            if (this.getAutoDeleteFlag()) {
                return this.delete(deletedEntry);
            }
        }
        return 2;
    }

    protected int delete(DeletedEntry deletedEntry) {
        File file = new File(deletedEntry.getFilename());
        File file2 = this.getServerFile(file);
        if (file2.exists()) {
            System.out.println("Deleting : " + file2);
            file2.delete();
            this.removeDelEntry(deletedEntry.getKey());
            return 5;
        }
        System.out.println("Nothing to delete : " + file2);
        this.removeDelEntry(deletedEntry.getKey());
        return 2;
    }

    public boolean getAutoDeleteFlag() {
        return this.getBoolean(ATTR_AUTO_DELETE, false);
    }

    public boolean getAutoPublishFlag() {
        return this.getBoolean(ATTR_AUTO_PUBLISH, false);
    }

    public File getCvsSpace() {
        return (File)this.getValue(ATTR_SPACE, null);
    }

    protected Enumeration getDelEntries() {
        return this.dentries.elements();
    }

    protected Enumeration getDelEntriesKeys() {
        return this.dentries.keys();
    }

    protected DeletedEntry getDelEntry(String string) {
        return (DeletedEntry)((Object)this.dentries.get(string));
    }

    public File getDelFile() {
        File file = this.getFile();
        if (file != null) {
            return new File(String.valueOf(String.valueOf(file)) + ".del");
        }
        return null;
    }

    protected Enumeration getEntries() {
        return this.entries.elements();
    }

    protected Enumeration getEntriesKeys() {
        return this.entries.keys();
    }

    protected PutedEntry getEntry(String string) {
        return (PutedEntry)((Object)this.entries.get(string));
    }

    public File getFile() {
        return (File)this.getValue(ATTR_FILE, null);
    }

    public int getMaxPublishedEntryStored() {
        return this.getInt(ATTR_MAX_PUBLISHED, 10);
    }

    public File getPubFile() {
        File file = this.getFile();
        if (file != null) {
            return new File(String.valueOf(String.valueOf(file)) + ".pub");
        }
        return null;
    }

    protected Enumeration getPublishedEntries() {
        return this.published.elements();
    }

    public File getRoot() {
        return (File)this.getValue(ATTR_ROOT, null);
    }

    protected File getServerFile(File file) {
        String string;
        String string2 = file.getAbsolutePath();
        if (!string2.startsWith(string = this.getCvsSpace().getAbsolutePath())) {
            return null;
        }
        return new File(this.getRoot(), string2.substring(string.length()));
    }

    public void initialize(Object[] objectArray) {
        File file;
        File file2;
        super.initialize(objectArray);
        File file3 = this.getFile();
        if (file3 != null && file3.exists()) {
            this.readList();
        }
        if ((file2 = this.getPubFile()) != null && file2.exists()) {
            this.readPubList();
        }
        if ((file = this.getDelFile()) != null && file.exists()) {
            this.readDelList();
        }
        this.props = this.getServer().getProperties();
        try {
            this.registerFrameIfNone("org.w3c.jigedit.filters.PutListFrame", "putlist-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected DeletedEntry lookupDelEntry(Request request) {
        ResourceReference resourceReference = request.getTargetResource();
        String string = request.getURL().toExternalForm();
        Resource resource = null;
        if (resourceReference != null) {
            try {
                try {
                    resource = resourceReference.lock();
                    if (resource instanceof FileResource) {
                        string = ((FileResource)resource).getFile().getAbsolutePath().toString();
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                resourceReference.unlock();
                throw throwable;
            }
            resourceReference.unlock();
        }
        return (DeletedEntry)((Object)this.dentries.get(string));
    }

    protected PutedEntry lookupEntry(Request request) {
        ResourceReference resourceReference = request.getTargetResource();
        String string = request.getURL().toExternalForm();
        Resource resource = null;
        if (resourceReference != null) {
            try {
                try {
                    resource = resourceReference.lock();
                    if (resource instanceof FileResource) {
                        string = ((FileResource)resource).getFile().getAbsolutePath().toString();
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                resourceReference.unlock();
                throw throwable;
            }
            resourceReference.unlock();
        }
        return (PutedEntry)((Object)this.entries.get(string));
    }

    public synchronized void notifyUnload() {
        this.writeList();
        this.writePubList();
        this.writeDelList();
        super.notifyUnload();
    }

    protected int publish(PutedEntry putedEntry) {
        File file = new File(putedEntry.getFilename());
        File file2 = this.getServerFile(file);
        int n = 2;
        try {
            block14: {
                String string;
                Object object;
                Object object2;
                File file3 = new File(file.getParent());
                CvsDirectory cvsDirectory = CvsDirectory.getManager((File)file3, (Properties)this.props);
                if (cvsDirectory.status(file.getName()) == 4) {
                    object2 = putedEntry.getAuthor();
                    object = new CvsDirectory[]{"USER=" + (String)object2, "LOGNAME=" + (String)object2};
                    string = object2 != null ? "Published by " + (String)object2 + " through Jigsaw" : "Published through Jigsaw";
                    cvsDirectory.commit(file.getName(), string, (String[])object);
                } else {
                    System.out.println("PutList: no commit needed on " + file.getAbsolutePath() + " st=" + cvsDirectory.status(file.getName()));
                }
                object2 = new File(file2.getParent());
                try {
                    object = CvsDirectory.getManager((File)object2, (Properties)this.props);
                    string = file2.getName();
                    int n2 = object.status(string);
                    System.out.println("publishing " + CvsDirectory.statusToString((int)n2) + " file : " + string);
                    if (n2 == 5) {
                        File file4 = new File(file2.getParent(), String.valueOf(string) + ".bak");
                        try {
                            IO.copy((File)file2, (File)file4);
                            object.update(string);
                            n2 = object.status(string);
                            if (n2 == 4) {
                                String string2 = putedEntry.getAuthor();
                                String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
                                String string3 = string2 != null ? "Merged by " + string2 + " through Jigsaw" : "Merged through Jigsaw";
                                object.commit(string, string3, stringArray);
                                file4.delete();
                                n = 3;
                            } else if (n2 == 5) {
                                file2.delete();
                                file4.renameTo(file2);
                                n = 4;
                            }
                            break block14;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            n = 4;
                        }
                        break block14;
                    }
                    if (n2 != 1) {
                        object.update(string);
                        n = 1;
                    } else {
                        System.out.println("PutList: no update needed on " + file2.getAbsolutePath() + " st=" + CvsDirectory.statusToString((int)n2));
                    }
                }
                catch (UncheckedOutException uncheckedOutException) {
                    object = new File(this.getRoot().getAbsolutePath());
                    string = CvsDirectory.getManager((File)object, (Properties)this.props);
                    String string4 = file.getAbsolutePath();
                    String string5 = this.getCvsSpace().getAbsolutePath();
                    String string6 = string4.substring(string5.length() + 1);
                    string.get(string6);
                    n = 1;
                }
            }
            this.entries.remove(putedEntry.getKey());
            putedEntry.setValue(PutedEntry.ATTR_TIME, new Long(System.currentTimeMillis()));
            this.addPubEntry(putedEntry);
        }
        catch (CvsException cvsException) {
            cvsException.printStackTrace();
        }
        return n;
    }

    protected synchronized void readDelList() {
        File file = this.getDelFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            AttributeHolder[] attributeHolderArray = serializer.readAttributeHolders((Reader)bufferedReader);
            int n = 0;
            while (n < attributeHolderArray.length) {
                DeletedEntry deletedEntry = (DeletedEntry)attributeHolderArray[n];
                deletedEntry.confirm();
                this.addDelEntry(deletedEntry);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected synchronized void readList() {
        File file = this.getFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            AttributeHolder[] attributeHolderArray = serializer.readAttributeHolders((Reader)bufferedReader);
            int n = 0;
            while (n < attributeHolderArray.length) {
                this.addEntry((PutedEntry)attributeHolderArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected synchronized void readPubList() {
        File file = this.getPubFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            AttributeHolder[] attributeHolderArray = serializer.readAttributeHolders((Reader)bufferedReader);
            int n = 0;
            while (n < attributeHolderArray.length) {
                this.addPubEntry((PutedEntry)attributeHolderArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void registerDeleteRequest(Request request) {
        DeletedEntry deletedEntry = (DeletedEntry)DeletedEntry.makeEntry(request);
        this.addDelEntry(deletedEntry);
    }

    public synchronized int registerRequest(Request request) {
        PutedEntry putedEntry = this.lookupEntry(request);
        if (putedEntry == null) {
            putedEntry = PutedEntry.makeEntry(request);
            this.addEntry(putedEntry);
        } else {
            putedEntry.update(request);
        }
        if (this.getAutoPublishFlag()) {
            return this.publish(putedEntry);
        }
        return 2;
    }

    protected void removeDelEntry(String string) {
        this.dentries.remove(string);
    }

    protected void removeEntry(String string) {
        this.entries.remove(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeOldestPublishedEntry() {
        Enumeration enumeration = this.published.elements();
        PutedEntry putedEntry = null;
        PutedEntry putedEntry2 = null;
        if (!enumeration.hasMoreElements()) return;
        putedEntry = (PutedEntry)((Object)enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            putedEntry2 = (PutedEntry)((Object)enumeration.nextElement());
            if (putedEntry2.getTime() >= putedEntry.getTime()) continue;
            putedEntry = putedEntry2;
        }
        this.published.remove(putedEntry.getKey());
    }

    protected synchronized void removePubEntry(String string) {
        this.published.remove(string);
    }

    protected synchronized void removeUnconfirmedDelEntries() {
        Enumeration enumeration = this.getDelEntries();
        while (enumeration.hasMoreElements()) {
            DeletedEntry deletedEntry = (DeletedEntry)((Object)enumeration.nextElement());
            if (deletedEntry.isConfirmed()) continue;
            this.removeDelEntry(deletedEntry.getKey());
        }
    }

    protected void setAutoDelete(boolean bl) {
        this.setValue(ATTR_AUTO_DELETE, new Boolean(bl));
    }

    protected void setAutoPublish(boolean bl) {
        this.setValue(ATTR_AUTO_PUBLISH, new Boolean(bl));
    }

    protected void setMaxPublishedEntryStored(int n) {
        this.setValue(ATTR_MAX_PUBLISHED, new Integer(n));
    }

    protected synchronized void write(File file, Enumeration enumeration) {
        block6: {
            if (file == null) {
                return;
            }
            File file2 = null;
            if (file.exists()) {
                file2 = new File(String.valueOf(String.valueOf(file)) + ".bak");
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
            }
            try {
                Vector vector = new Vector(10);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                Object[] objectArray = new AttributeHolder[vector.size()];
                vector.copyInto(objectArray);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                serializer.writeResources((AttributeHolder[])objectArray, (Writer)bufferedWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (file2 == null) break block6;
                file2.renameTo(file);
            }
        }
    }

    protected synchronized void writeDelList() {
        this.write(this.getDelFile(), this.getDelEntries());
    }

    protected synchronized void writeList() {
        this.write(this.getFile(), this.entries.elements());
    }

    protected synchronized void writePubList() {
        this.write(this.getPubFile(), this.published.elements());
    }
}

